/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.authentication.GenericAuthentificationHandler;
import org.esigate.http.GenericHttpRequest;
import org.esigate.util.HttpRequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthenticationHandler
extends GenericAuthentificationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticationHandler.class);
    private final List<String> sessionAttributes = new ArrayList<String>();
    private final List<String> requestAttributes = new ArrayList<String>();
    private String headerPrefix = "X-ATTR-";

    public boolean beforeProxy(HttpRequest httpRequest) {
        return true;
    }

    public void init(Properties properties) {
        String headerPrefixProperty;
        String requestAttributesProperty;
        String sessionAttributesProperty = properties.getProperty("forwardSessionAttributes");
        if (sessionAttributesProperty != null) {
            String[] attributes;
            for (String attribute : attributes = sessionAttributesProperty.split(",")) {
                this.sessionAttributes.add(attribute.trim());
                if (!logger.isInfoEnabled()) continue;
                logger.info("Forwading session attribute: " + attribute);
            }
        }
        if ((requestAttributesProperty = (String)properties.get("forwardRequestAttributes")) != null) {
            String[] attributes;
            for (String attribute : attributes = requestAttributesProperty.split(",")) {
                this.requestAttributes.add(attribute.trim());
                if (!logger.isInfoEnabled()) continue;
                logger.info("Forwading request attribute: " + attribute);
            }
        }
        if ((headerPrefixProperty = (String)properties.get("headerPrefix")) != null) {
            this.headerPrefix = headerPrefixProperty;
        }
    }

    public boolean needsNewRequest(HttpResponse response, HttpRequest httpRequest) {
        return false;
    }

    public void preRequest(GenericHttpRequest request, HttpRequest httpRequest) {
        String value;
        if (logger.isDebugEnabled()) {
            logger.debug("preRequest");
        }
        ContainerRequestMediator mediator = HttpRequestHelper.getMediator(httpRequest);
        for (String attribute : this.sessionAttributes) {
            value = (String)((Object)mediator.getSessionAttribute(attribute));
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding session attribute " + attribute + " (" + value + ") as header (" + this.headerPrefix + attribute + ")");
            }
            request.addHeader(this.headerPrefix + attribute, value);
        }
        for (String attribute : this.requestAttributes) {
            value = (String)httpRequest.getParams().getParameter(attribute);
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding request attribute " + attribute + " (" + value + ") as header (" + this.headerPrefix + attribute + ")");
            }
            request.addHeader(this.headerPrefix + attribute, value);
        }
    }
}

