/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.esi.EsiRenderer;
import org.esigate.servlet.HttpRequestImpl;
import org.esigate.servlet.HttpResponseImpl;
import org.esigate.servlet.ResponseCapturingWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyFilter.class);
    private Pattern[] mappings;
    private Driver[] providers;

    public void init(FilterConfig filterConfig) throws ServletException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/esigate-mapping.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        int size = properties.size();
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        this.mappings = new Pattern[size];
        this.providers = new Driver[size];
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            this.mappings[i] = Pattern.compile((String)entry.getKey());
            this.providers[i] = DriverFactory.getInstance((String)entry.getValue());
            ++i;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String relUrl = httpServletRequest.getRequestURI();
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].matcher(relUrl).matches()) continue;
            LOG.debug("Proxying " + relUrl);
            try {
                this.providers[i].proxy(relUrl, HttpRequestImpl.wrap(httpServletRequest), HttpResponseImpl.wrap(httpServletResponse), new EsiRenderer());
            }
            catch (HttpErrorPage e) {
                httpServletResponse.setStatus(e.getStatusCode());
                httpServletResponse.getWriter().write(e.getErrorPageContent());
            }
            return;
        }
        LOG.debug("Calling local resource " + relUrl);
        ResponseCapturingWrapper wrappedResponse = new ResponseCapturingWrapper(httpServletResponse);
        chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)wrappedResponse);
        String result = wrappedResponse.getResult();
        if (result != null) {
            ResourceContext resourceContext = new ResourceContext(null, relUrl, null, HttpRequestImpl.wrap(httpServletRequest), HttpResponseImpl.wrap(httpServletResponse));
            try {
                new EsiRenderer().render(resourceContext, result, response.getWriter());
            }
            catch (HttpErrorPage e) {
                httpServletResponse.setStatus(e.getStatusCode());
                httpServletResponse.getWriter().write(e.getErrorPageContent());
            }
        }
    }

    public void destroy() {
    }
}

