/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.esigate.api.HttpResponse;

public class HttpResponseImpl
implements HttpResponse {
    private final HttpServletResponse parent;

    private HttpResponseImpl(HttpServletResponse parent) {
        this.parent = parent;
    }

    public static HttpResponse wrap(HttpServletResponse parent) {
        return new HttpResponseImpl(parent);
    }

    public void addCookie(org.esigate.api.Cookie src) {
        Cookie servletCookie = new Cookie(src.getName(), src.getValue());
        if (src.getDomain() != null) {
            servletCookie.setDomain(src.getDomain());
        }
        servletCookie.setPath(src.getPath());
        servletCookie.setSecure(src.isSecure());
        servletCookie.setComment(src.getComment());
        servletCookie.setVersion(src.getVersion());
        if (src.getExpiryDate() != null) {
            int maxAge = (int)(src.getExpiryDate().getTime() - System.currentTimeMillis()) / 1000;
            if (maxAge < 0) {
                maxAge = 0;
            }
            servletCookie.setMaxAge(maxAge);
        }
        this.parent.addCookie(servletCookie);
    }

    public void setStatus(int sc) {
        this.parent.setStatus(sc);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.parent.getOutputStream();
    }

    public Writer getWriter() throws IOException {
        return this.parent.getWriter();
    }

    public void addHeader(String name, String value) {
        this.parent.addHeader(name, value);
    }

    public void setCharacterEncoding(String charset) {
        this.parent.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.parent.setContentLength(len);
    }

    public void setContentType(String type) {
        this.parent.setContentType(type);
    }
}

