/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.ehcache.EhcacheHttpCacheStorage;
import org.esigate.Parameters;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.cache.CacheStorage;

public class EhcacheCacheStorage
extends CacheStorage {
    public static final String DEFAULT_CACHE_NAME = "EsiGate";

    public void init(Properties properties) {
        String cacheName = Parameters.EHCACHE_CACHE_NAME_PROPERTY.getValueString(properties);
        String configurationFileName = Parameters.EHCACHE_CONFIGURATION_FILE_PROPERTY.getValueString(properties);
        CacheManager cacheManager = CacheManager.create((String)configurationFileName);
        Ehcache ehcache = cacheManager.getEhcache(cacheName);
        if (ehcache == null) {
            cacheManager.addCache(cacheName);
            ehcache = cacheManager.getEhcache(cacheName);
        }
        CacheConfig cacheConfig = CacheConfigHelper.createCacheConfig(properties);
        this.impl = new EhcacheHttpCacheStorage(ehcache, cacheConfig);
    }
}

