/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import org.esigate.api.HttpRequest;
import org.esigate.api.HttpSession;

public class UserContext {
    private static final String USER_KEY = "user";
    private final HttpRequest httpRequest;
    private final String key;

    public UserContext(HttpRequest httpRequest, String key) {
        this.httpRequest = httpRequest;
        this.key = UserContext.class.getName() + "#" + key;
    }

    private String prefixAttributeName(String name) {
        return this.key + "#" + name;
    }

    public Object getAttribute(String name) {
        HttpSession httpSession = this.httpRequest.getSession(false);
        if (httpSession != null) {
            return httpSession.getAttribute(this.prefixAttributeName(name));
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        HttpSession httpSession = this.httpRequest.getSession(true);
        httpSession.setAttribute(this.prefixAttributeName(name), value);
    }

    public String getUser() {
        return (String)this.getAttribute(USER_KEY);
    }

    public void setUser(String user) {
        this.setAttribute(USER_KEY, user);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("User=").append(this.getUser());
        return result.toString();
    }
}

