/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Driver;

public class DriverFactory {
    private static final Map<String, Driver> INSTANCES = new HashMap<String, Driver>();
    private static final String DEFAULT_INSTANCE_NAME = "default";

    private DriverFactory() {
    }

    public static final void configure() {
        InputStream inputStream = Driver.class.getResourceAsStream("driver.properties");
        InputStream extInputStream = DriverFactory.class.getClassLoader().getResourceAsStream("driver-ext.properties");
        try {
            Properties merged = new Properties();
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                merged.putAll((Map<?, ?>)props);
            }
            if (extInputStream != null) {
                Properties extProps = new Properties();
                extProps.load(extInputStream);
                merged.putAll((Map<?, ?>)extProps);
            }
            DriverFactory.configure(merged);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error loading configuration", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (extInputStream != null) {
                    extInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void configure(Properties props) {
        Properties defaultProperties = new Properties();
        HashMap<String, Properties> driversProps = new HashMap<String, Properties>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            String value = props.getProperty(propertyName);
            int idx = propertyName.lastIndexOf(46);
            if (idx < 0) {
                defaultProperties.put(propertyName, value);
                continue;
            }
            String prefix = propertyName.substring(0, idx);
            String name = propertyName.substring(idx + 1);
            Properties driverProperties = (Properties)driversProps.get(prefix);
            if (driverProperties == null) {
                driverProperties = new Properties();
                driversProps.put(prefix, driverProperties);
            }
            driverProperties.put(name, value);
        }
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            INSTANCES.clear();
            for (Map.Entry entry : driversProps.entrySet()) {
                String name = (String)entry.getKey();
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)defaultProperties);
                properties.putAll((Map<?, ?>)((Map)entry.getValue()));
                DriverFactory.configure(name, properties);
            }
            if (INSTANCES.get(DEFAULT_INSTANCE_NAME) == null) {
                DriverFactory.configure(DEFAULT_INSTANCE_NAME, defaultProperties);
            }
        }
    }

    public static void configure(String name, Properties props) {
        INSTANCES.put(name, new Driver(name, props));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Driver getInstance(String instanceName) {
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            if (instanceName == null) {
                instanceName = DEFAULT_INSTANCE_NAME;
            }
            if (INSTANCES.isEmpty()) {
                throw new ConfigurationException("Driver has not been configured and driver.properties file was not found");
            }
            Driver instance = INSTANCES.get(instanceName);
            if (instance == null) {
                throw new ConfigurationException("No configuration properties found for factory : " + instanceName);
            }
            return instance;
        }
    }

    public static final Driver getInstance() {
        return DriverFactory.getInstance(DEFAULT_INSTANCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void put(String instanceName, Driver instance) {
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(instanceName, instance);
        }
    }

    static {
        DriverFactory.configure();
    }
}

