/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.esigate.DriverConfiguration;
import org.esigate.output.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource {
    public abstract void render(Output var1) throws IOException;

    public abstract void release();

    public abstract int getStatusCode();

    public abstract String getStatusMessage();

    public boolean isError() {
        int statusCode = this.getStatusCode();
        return statusCode != 200 && statusCode != 302 && statusCode != 301 && statusCode != 304;
    }

    public abstract String getHeader(String var1);

    public abstract Collection<String> getHeaders(String var1);

    public abstract Collection<String> getHeaderNames();

    public String getRequestHeader(String name) {
        return null;
    }

    public boolean hasResponseBody() {
        switch (this.getStatusCode()) {
            case 200: 
            case 206: {
                return true;
            }
        }
        return false;
    }

    public Date getLocalDate() {
        return null;
    }

    public void copyHeaders(DriverConfiguration config, Output output) {
        for (String headerName : this.getHeaderNames()) {
            if (!config.isForwardedResponseHeader(headerName)) continue;
            Collection<String> values = this.getHeaders(headerName);
            for (String value : values) {
                output.addHeader(headerName, value);
            }
        }
    }
}

