/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.esigate.api.HttpResponse;
import org.esigate.output.Output;
import org.esigate.output.OutputException;
import org.esigate.resource.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOnlyStringOutput
extends Output {
    private final HttpResponse response;
    private final Collection<String> contentTypes;
    private ByteArrayOutputStream byteArrayOutputStream;
    private OutputStream outputStream;

    public TextOnlyStringOutput(HttpResponse response, Collection<String> contentTypes) {
        this.response = response;
        this.contentTypes = contentTypes;
    }

    public boolean hasTextBuffer() throws IllegalStateException {
        return this.byteArrayOutputStream != null;
    }

    @Override
    public void open() throws IOException {
        this.response.setStatus(this.getStatusCode());
        boolean text = ResourceUtils.isTextContentType(this.getHeader("Content-Type"), this.contentTypes);
        this.copyHeaders(text);
        if (text) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        } else {
            this.outputStream = this.response.getOutputStream();
        }
    }

    private void copyHeaders(boolean text) {
        for (Map.Entry<String, Set<String>> entry : this.getHeaders().entrySet()) {
            if (text && "content-length".equalsIgnoreCase(entry.getKey())) continue;
            Set<String> values = entry.getValue();
            for (String value : values) {
                this.response.addHeader(entry.getKey(), value);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.byteArrayOutputStream != null) {
            return this.byteArrayOutputStream;
        }
        return this.outputStream;
    }

    public String toString() {
        if (this.byteArrayOutputStream == null) {
            return "<Unparsed binary data: Content-Type=" + this.getHeader("Content-Type") + " >";
        }
        String charsetName = this.getCharsetName();
        if (charsetName == null) {
            charsetName = "ISO-8859-1";
        }
        try {
            return this.byteArrayOutputStream.toString(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new OutputException(e);
        }
    }
}

