/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.esigate.ResourceContext;
import org.esigate.api.Cookie;
import org.esigate.cookie.BasicClientCookie;
import org.esigate.http.HttpClientRequest;
import org.esigate.http.SerializableBasicClientCookie2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestCookieStore
implements CookieStore {
    private static final Logger LOG = LoggerFactory.getLogger(RequestCookieStore.class);
    private final Collection<String> discardCookies;
    private final Collection<String> forwardCookies;
    private final CookieStore actualCookieStore;
    private final ResourceContext resourceContext;

    public RequestCookieStore(Collection<String> discardCookies, Collection<String> forwardCookies, CookieStore actualCookieStore, HttpClientRequest request, ResourceContext resourceContext) {
        this.discardCookies = discardCookies;
        this.forwardCookies = forwardCookies;
        this.actualCookieStore = actualCookieStore;
        this.resourceContext = resourceContext;
    }

    public void addCookie(org.apache.http.cookie.Cookie cookie) {
        String name = cookie.getName();
        if (this.discardCookies.contains(name) || this.discardCookies.contains("*") && !this.forwardCookies.contains(name)) {
            LOG.info("Cookie " + this.toString(cookie) + " -> discarding");
        } else if (this.forwardCookies.contains(name) || this.forwardCookies.contains("*")) {
            LOG.info("Cookie " + this.toString(cookie) + " -> forwarding");
            this.resourceContext.getOriginalResponse().addCookie(RequestCookieStore.rewrite(cookie, this.resourceContext));
        } else {
            LOG.info("Cookie " + this.toString(cookie) + " -> storing to context");
            this.actualCookieStore.addCookie(cookie);
        }
    }

    private String toString(org.apache.http.cookie.Cookie cookie) {
        StringBuilder result = new StringBuilder();
        result.append(cookie.getName());
        result.append("=");
        result.append(cookie.getValue());
        if (cookie.getDomain() != null) {
            result.append(";domain=");
            result.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            result.append(";path=");
            result.append(cookie.getPath());
        }
        if (cookie.getExpiryDate() != null) {
            result.append(";expires=");
            result.append(cookie.getExpiryDate());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getComment());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getCommentURL());
        }
        return result.toString();
    }

    static Cookie rewrite(org.apache.http.cookie.Cookie cookie, ResourceContext resourceContext) {
        String name = cookie.getName();
        if ("JSESSIONID".equalsIgnoreCase(name)) {
            name = "_" + name;
        }
        String domain = RequestCookieStore.rewriteDomain(cookie.getDomain(), resourceContext.getBaseURLasURL().getHost(), resourceContext.getOriginalRequest().getServerName());
        String originalPath = cookie.getPath();
        String requestPath = resourceContext.getOriginalRequest().getRequestURI();
        String path = originalPath;
        if (requestPath == null || !requestPath.startsWith(originalPath)) {
            path = "/";
        }
        boolean secure = cookie.isSecure() && resourceContext.getOriginalRequest().isSecure();
        BasicClientCookie cookieToForward = new BasicClientCookie(name, cookie.getValue());
        if (domain != null) {
            cookieToForward.setDomain(domain);
        }
        cookieToForward.setPath(path);
        cookieToForward.setSecure(secure);
        cookieToForward.setComment(cookie.getComment());
        cookieToForward.setVersion(cookie.getVersion());
        cookieToForward.setExpiryDate(cookie.getExpiryDate());
        LOG.debug("Forwarding cookie {} -> {}", (Object)cookie.toString(), (Object)cookieToForward.toString());
        return cookieToForward;
    }

    static String rewriteDomain(String originalDomain, String providerHostName, String requestHostName) {
        String domain = null;
        if (!providerHostName.equals(originalDomain)) {
            String[] requestHostNameParts;
            String[] originalDomainParts;
            int targetLength;
            if (originalDomain.startsWith(".")) {
                originalDomain = originalDomain.substring(1);
            }
            if ((targetLength = Math.min((originalDomainParts = originalDomain.split("\\.")).length, (requestHostNameParts = requestHostName.split("\\.")).length)) == requestHostNameParts.length) {
                return null;
            }
            domain = "";
            for (int i = requestHostNameParts.length; i > requestHostNameParts.length - targetLength; --i) {
                domain = "." + requestHostNameParts[i - 1] + domain;
            }
        }
        return domain;
    }

    public List<org.apache.http.cookie.Cookie> getCookies() {
        ArrayList<org.apache.http.cookie.Cookie> cookies = new ArrayList<org.apache.http.cookie.Cookie>();
        cookies.addAll(this.actualCookieStore.getCookies());
        Cookie[] requestCookies = this.resourceContext.getOriginalRequest().getCookies();
        if (requestCookies != null) {
            for (Cookie cookie : requestCookies) {
                String name = cookie.getName();
                if (!this.forwardCookies.contains(name) && (!this.forwardCookies.contains("*") || this.discardCookies.contains(name))) continue;
                cookies.add(RequestCookieStore.toApacheCookie(cookie, this.resourceContext));
            }
        }
        return cookies;
    }

    static org.apache.http.cookie.Cookie toApacheCookie(Cookie cookie, ResourceContext resourceContext) {
        String name = cookie.getName();
        if ("_JSESSIONID".equalsIgnoreCase(name)) {
            name = name.substring(1);
        }
        SerializableBasicClientCookie2 httpClientCookie = new SerializableBasicClientCookie2(name, cookie.getValue());
        httpClientCookie.setSecure(false);
        String domain = resourceContext.getDriver().getConfiguration().isPreserveHost() ? resourceContext.getOriginalRequest().getServerName() : resourceContext.getBaseURLasURL().getHost();
        httpClientCookie.setDomain(domain);
        httpClientCookie.setPath("/");
        httpClientCookie.setComment(cookie.getComment());
        httpClientCookie.setVersion(cookie.getVersion());
        return httpClientCookie;
    }

    public boolean clearExpired(Date date) {
        return this.actualCookieStore.clearExpired(date);
    }

    public void clear() {
        this.actualCookieStore.clear();
    }
}

