/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.esigate.http.BrowserCompatVersionAttributeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserCompatSpec
extends org.apache.http.impl.cookie.BrowserCompatSpec {
    public BrowserCompatSpec() {
        this.registerAttribHandler("version", (CookieAttributeHandler)new BrowserCompatVersionAttributeHandler());
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("List of cookies may not be null");
        }
        if (cookies.isEmpty()) {
            throw new IllegalArgumentException("List of cookies may not be empty");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            BasicHeaderValueFormatter.DEFAULT.formatHeaderElement(buffer, (HeaderElement)new BasicHeaderElement(cookie.getName(), cookie.getValue()), false);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add((Header)new BufferedHeader(buffer));
        return headers;
    }
}

