/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.ResourceContext;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.EsiFragmentRenderer;
import org.esigate.esi.EsiRenderer;
import org.esigate.esi.FragmentReplacementElement;
import org.esigate.esi.InlineCache;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.Parser;
import org.esigate.parser.ParserContext;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.vars.VariablesResolver;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;

class IncludeElement
extends BaseElement {
    private static final Pattern FRAGMENT_REPLACEMENT_PATTERN = Pattern.compile("(<esi:fragment[^>]*>)|(</esi:fragment[^>]*>)");
    public static final ElementType TYPE = new BaseElementType("<esi:include", "</esi:include"){

        public IncludeElement newInstance() {
            return new IncludeElement();
        }
    };
    private final Appendable outAdapter = new Appendable(){

        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            IncludeElement.this.characters(csq, start, end);
            return this;
        }

        public Appendable append(char c) throws IOException {
            return this.append(new StringBuilder(1).append(c), 0, 1);
        }

        public Appendable append(CharSequence csq) throws IOException {
            return this.append(csq, 0, csq.length());
        }
    };
    private StringBuilder buf;
    private Map<String, CharSequence> fragmentRepacements;
    private Map<String, CharSequence> regexpRepacements;

    IncludeElement() {
    }

    public void characters(CharSequence csq, int start, int end) {
        this.buf.append(csq, start, end);
    }

    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        if (!this.fragmentRepacements.isEmpty()) {
            StringBuilder tmp = new StringBuilder(this.buf.length());
            Parser fragmentReplacementParser = new Parser(FRAGMENT_REPLACEMENT_PATTERN, FragmentReplacementElement.createType(this.fragmentRepacements));
            fragmentReplacementParser.parse(this.buf, tmp);
            this.buf = tmp;
        }
        if (!this.regexpRepacements.isEmpty()) {
            for (Map.Entry<String, CharSequence> entry : this.regexpRepacements.entrySet()) {
                this.buf = new StringBuilder(Pattern.compile(entry.getKey()).matcher(this.buf).replaceAll(entry.getValue().toString()));
            }
        }
        ctx.getCurrent().characters(this.buf, 0, this.buf.length());
        this.buf = null;
        this.fragmentRepacements = null;
        this.regexpRepacements = null;
    }

    protected void parseTag(Tag tag, ParserContext ctx) throws IOException, HttpErrorPage {
        block5: {
            this.buf = new StringBuilder();
            this.fragmentRepacements = new HashMap<String, CharSequence>();
            this.regexpRepacements = new HashMap<String, CharSequence>();
            String src = tag.getAttribute("src");
            String alt = tag.getAttribute("alt");
            boolean ignoreError = "continue".equals(tag.getAttribute("onerror"));
            try {
                try {
                    this.processPage(src, tag, ctx);
                }
                catch (Exception e) {
                    if (alt != null) {
                        this.processPage(alt, tag, ctx);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (ignoreError || ctx.reportError(e)) break block5;
                HttpErrorPage httpErrorPage = new HttpErrorPage(404, "Not found", "The page: " + src + " does not exist");
                httpErrorPage.initCause(e);
                throw httpErrorPage;
            }
        }
    }

    void processPage(String src, Tag tag, ParserContext ctx) throws IOException, HttpErrorPage {
        Driver driver;
        String page;
        int idx;
        String fragment = tag.getAttribute("fragment");
        String xpath = tag.getAttribute("xpath");
        String xslt = tag.getAttribute("stylesheet");
        boolean noStore = "on".equalsIgnoreCase(tag.getAttribute("no-store"));
        String ttl = tag.getAttribute("ttl");
        String maxWait = tag.getAttribute("maxwait");
        boolean rewriteAbsoluteUrl = "true".equalsIgnoreCase(tag.getAttribute("rewriteabsoluteurl"));
        ResourceContext resourceContext = ctx.getResourceContext();
        ArrayList<Renderer> rendererList = new ArrayList<Renderer>();
        if (maxWait != null) {
            try {
                resourceContext.getOriginalRequest().setFetchMaxWait(Integer.parseInt(maxWait));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (resourceContext != null) {
            resourceContext.getOriginalRequest().setNoStoreResource(noStore);
            if (!noStore && ttl != null) {
                String timePeriod = ttl.substring(ttl.length() - 1);
                Long time = null;
                try {
                    time = Long.parseLong(ttl.substring(0, ttl.length() - 1));
                    if (timePeriod.equalsIgnoreCase("d")) {
                        time = time * 86400000L;
                    } else if (timePeriod.equalsIgnoreCase("h")) {
                        time = time * 3600000L;
                    } else if (timePeriod.equalsIgnoreCase("m")) {
                        time = time * 60000L;
                    } else if (timePeriod.equalsIgnoreCase("s")) {
                        time = time * 1000L;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                resourceContext.getOriginalRequest().setResourceTtl(time);
            }
        }
        if ((idx = src.indexOf("$PROVIDER({")) < 0) {
            page = src;
            driver = ctx.getResourceContext().getDriver();
        } else {
            int startIdx = idx + "$PROVIDER({".length();
            int endIndex = src.indexOf("})", startIdx);
            String provider = src.substring(startIdx, endIndex);
            page = src.substring(endIndex + "})".length());
            driver = DriverFactory.getInstance(provider);
        }
        if (rewriteAbsoluteUrl) {
            HashMap<String, String> replaceRules = new HashMap<String, String>();
            String baseUrl = resourceContext.getBaseURL();
            String visibleBaseUrl = driver.getConfiguration().getVisibleBaseURL(baseUrl);
            if (visibleBaseUrl != null && !visibleBaseUrl.equals("") && !baseUrl.equals(visibleBaseUrl)) {
                String contextBaseUrl = new URL(baseUrl).getPath();
                String contextVisibleBaseUrl = new URL(visibleBaseUrl).getPath();
                replaceRules.put("href=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "href=$1" + contextVisibleBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "src=$1" + contextVisibleBaseUrl + "$2$3");
                replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
            } else {
                String contextBaseUrl = new URL(baseUrl).getPath();
                replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
            }
            rendererList.add(new ReplaceRenderer(replaceRules));
        }
        page = VariablesResolver.replaceAllVariables(page, resourceContext.getOriginalRequest());
        InlineCache ic = InlineCache.getFragment(src);
        if (ic != null && !ic.isExpired()) {
            String cache = ic.getFragment();
            this.characters(cache, 0, cache.length());
        } else {
            if (fragment != null) {
                rendererList.add(new EsiFragmentRenderer(page, fragment));
            } else if (xpath != null) {
                rendererList.add(new XpathRenderer(xpath));
            } else if (xslt != null) {
                rendererList.add(new XsltRenderer(xslt, driver, resourceContext));
            }
            rendererList.add(new EsiRenderer());
            driver.render(page, this.outAdapter, resourceContext, rendererList.toArray(new Renderer[rendererList.size()]));
        }
    }

    void addFragmentReplacement(String fragment, CharSequence replacement) {
        this.fragmentRepacements.put(fragment, replacement);
    }

    void addRegexpReplacement(String regexp, CharSequence replacement) {
        this.regexpRepacements.put(regexp, replacement);
    }
}

