/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.esigate.Parameters;
import org.esigate.extension.Extension;

public class CacheAdapter
implements Extension {
    private static final String STATUS_CODE_HEADER = "Status-code";
    private static final String REASON_PHRASE_HEADER = "Reason-phrase";
    private int staleIfError;
    private int staleWhileRevalidate;
    private int ttl;

    public void init(Properties properties) {
        this.staleIfError = Parameters.STALE_IF_ERROR.getValueInt(properties);
        this.staleWhileRevalidate = Parameters.STALE_WHILE_REVALIDATE.getValueInt(properties);
        this.ttl = Parameters.TTL.getValueInt(properties);
    }

    public HttpClient wrapCachingHttpClient(HttpClient wrapped) {
        return new HttpClientWrapper(wrapped){

            void transformRequest(HttpRequest httpRequest) {
            }

            void transformResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
                Header realStatusCode = httpResponse.getFirstHeader(CacheAdapter.STATUS_CODE_HEADER);
                Header realStatusText = httpResponse.getFirstHeader(CacheAdapter.REASON_PHRASE_HEADER);
                if (realStatusCode != null) {
                    int realStatusCodeInt = Integer.parseInt(realStatusCode.getValue());
                    String realReasonPhraseString = realStatusText.getValue();
                    httpResponse.setStatusCode(realStatusCodeInt);
                    httpResponse.setReasonPhrase(realReasonPhraseString);
                    httpResponse.removeHeaders(CacheAdapter.STATUS_CODE_HEADER);
                    httpResponse.removeHeaders(CacheAdapter.REASON_PHRASE_HEADER);
                }
                if (httpRequest.getRequestLine().getMethod().equalsIgnoreCase("GET") && (CacheAdapter.this.staleWhileRevalidate > 0 || CacheAdapter.this.staleIfError > 0)) {
                    httpResponse.removeHeader(httpResponse.getLastHeader("Cache-control"));
                }
            }
        };
    }

    public HttpClient wrapBackendHttpClient(HttpClient wrapped) {
        return new HttpClientWrapper(wrapped){

            void transformRequest(HttpRequest httpRequest) {
            }

            void transformResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
                if (CacheAdapter.this.ttl > 0 && httpRequest.getRequestLine().getMethod().equalsIgnoreCase("GET")) {
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        httpResponse.setHeader(CacheAdapter.STATUS_CODE_HEADER, Integer.toString(httpResponse.getStatusLine().getStatusCode()));
                        httpResponse.setHeader(CacheAdapter.REASON_PHRASE_HEADER, httpResponse.getStatusLine().getReasonPhrase());
                        httpResponse.setStatusCode(200);
                        httpResponse.setReasonPhrase("OK");
                    }
                    httpResponse.removeHeaders("Cache-control");
                    httpResponse.removeHeaders("Expires");
                    httpResponse.setHeader("Cache-control", "public,max-age=" + CacheAdapter.this.ttl);
                }
                if (httpRequest.getRequestLine().getMethod().equalsIgnoreCase("GET")) {
                    String cacheControlHeader = "";
                    if (CacheAdapter.this.staleWhileRevalidate > 0) {
                        cacheControlHeader = cacheControlHeader + "stale-while-revalidate=" + CacheAdapter.this.staleWhileRevalidate;
                    }
                    if (CacheAdapter.this.staleIfError > 0) {
                        if (cacheControlHeader.length() > 0) {
                            cacheControlHeader = cacheControlHeader + ",";
                        }
                        cacheControlHeader = cacheControlHeader + "stale-if-error=" + CacheAdapter.this.staleIfError;
                    }
                    if (cacheControlHeader.length() > 0) {
                        httpResponse.addHeader("Cache-control", cacheControlHeader);
                    }
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HttpClientWrapper
    implements HttpClient {
        private final HttpClient wrapped;

        HttpClientWrapper(HttpClient wrapped) {
            this.wrapped = wrapped;
        }

        public HttpParams getParams() {
            return this.wrapped.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.wrapped.getConnectionManager();
        }

        public <T> T execute(HttpHost target, final HttpRequest request, final ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            this.transformRequest(request);
            return (T)this.wrapped.execute(target, request, new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    HttpClientWrapper.this.transformResponse(request, response);
                    return responseHandler.handleResponse(response);
                }
            }, context);
        }

        public <T> T execute(HttpHost target, final HttpRequest request, final ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            this.transformRequest(request);
            return (T)this.wrapped.execute(target, request, new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    HttpClientWrapper.this.transformResponse(request, response);
                    return responseHandler.handleResponse(response);
                }
            });
        }

        public <T> T execute(final HttpUriRequest request, final ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            this.transformRequest((HttpRequest)request);
            return (T)this.wrapped.execute(request, new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    HttpClientWrapper.this.transformResponse((HttpRequest)request, response);
                    return responseHandler.handleResponse(response);
                }
            }, context);
        }

        public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            this.transformRequest(request);
            HttpResponse response = this.wrapped.execute(target, request, context);
            this.transformResponse(request, response);
            return response;
        }

        public <T> T execute(final HttpUriRequest request, final ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            this.transformRequest((HttpRequest)request);
            return (T)this.wrapped.execute(request, new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    HttpClientWrapper.this.transformResponse((HttpRequest)request, response);
                    return responseHandler.handleResponse(response);
                }
            });
        }

        public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            this.transformRequest(request);
            HttpResponse response = this.wrapped.execute(target, request);
            this.transformResponse(request, response);
            return response;
        }

        public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            this.transformRequest((HttpRequest)request);
            HttpResponse response = this.wrapped.execute(request, context);
            this.transformResponse((HttpRequest)request, response);
            return response;
        }

        public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            this.transformRequest((HttpRequest)request);
            HttpResponse response = this.wrapped.execute(request);
            this.transformResponse((HttpRequest)request, response);
            return response;
        }

        abstract void transformRequest(HttpRequest var1);

        abstract void transformResponse(HttpRequest var1, HttpResponse var2);
    }
}

