/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.url.IpHashBaseUrlRetrieveStrategy;
import org.esigate.url.RoundRobinBaseUrlRetrieveStrategy;
import org.esigate.url.SingleBaseUrlRetrieveStrategy;
import org.esigate.url.StickySessionBaseUrlRetrieveStrategy;
import org.esigate.util.FilterList;
import org.esigate.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfiguration {
    private final String instanceName;
    private final String uriEncoding;
    private final boolean fixResources;
    private final String visibleBaseURL;
    private final int fixMode;
    private final String authenticationHandler;
    private final Properties properties;
    private final boolean preserveHost;
    private final String cookieStore;
    private final String filter;
    private final List<String> parsableContentTypes;
    private final FilterList requestHeadersFilterList;
    private final FilterList responseHeadersFilterList;
    private final BaseUrlRetrieveStrategy baseUrlRetrieveStrategy;
    private final boolean isVisibleBaseURLEmpty;

    public DriverConfiguration(String instanceName, Properties props) {
        this.instanceName = instanceName;
        this.baseUrlRetrieveStrategy = this.getBaseUrlRetrieveSession(props);
        this.uriEncoding = Parameters.URI_ENCODING.getValueString(props);
        this.authenticationHandler = Parameters.AUTHENTICATION_HANDLER.getValueString(props);
        this.cookieStore = Parameters.COOKIE_STORE.getValueString(props);
        this.filter = Parameters.FILTER.getValueString(props);
        this.preserveHost = Parameters.PRESERVE_HOST.getValueBoolean(props);
        this.fixResources = Parameters.FIX_RESOURCES.getValueBoolean(props);
        this.visibleBaseURL = Parameters.VISIBLE_URL_BASE.getValueString(props);
        this.isVisibleBaseURLEmpty = StringUtils.isEmpty((CharSequence)this.visibleBaseURL);
        this.fixMode = "absolute".equalsIgnoreCase(Parameters.FIX_MODE.getValueString(props)) ? 0 : 1;
        String strContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueString(props);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        this.parsableContentTypes = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
        this.requestHeadersFilterList = new FilterList();
        this.responseHeadersFilterList = new FilterList();
        this.requestHeadersFilterList.add(Collections.singletonList("*"));
        this.responseHeadersFilterList.add(Collections.singletonList("*"));
        PropertiesUtil.populate(this.requestHeadersFilterList, props, Parameters.FORWARD_REQUEST_HEADERS.name, Parameters.DISCARD_REQUEST_HEADERS.name, "", Parameters.DISCARD_REQUEST_HEADERS.defaultValue);
        PropertiesUtil.populate(this.responseHeadersFilterList, props, Parameters.FORWARD_RESPONSE_HEADERS.name, Parameters.DISCARD_RESPONSE_HEADERS.name, "", Parameters.DISCARD_RESPONSE_HEADERS.defaultValue);
        this.properties = props;
    }

    private BaseUrlRetrieveStrategy getBaseUrlRetrieveSession(Properties props) {
        BaseUrlRetrieveStrategy urlStrategy;
        block7: {
            urlStrategy = null;
            String baseURLs = Parameters.REMOTE_URL_BASE.getValueString(props);
            try {
                if (StringUtils.isEmpty((CharSequence)baseURLs)) break block7;
                String[] urls = StringUtils.split((String)baseURLs, (String)",");
                if (1 == urls.length) {
                    String baseURL = StringUtils.trimToEmpty((String)urls[0]);
                    new URL(baseURL);
                    urlStrategy = new SingleBaseUrlRetrieveStrategy(baseURL);
                    break block7;
                }
                if (urls.length <= 0) break block7;
                String[] urlArr = new String[urls.length];
                for (int i = 0; i < urls.length; ++i) {
                    String baseURL = StringUtils.trimToEmpty((String)urls[i]);
                    new URL(baseURL);
                    urlArr[i] = baseURL;
                }
                String strategy = Parameters.REMOTE_URL_BASE_STRATEGY.getValueString(props);
                if ("roundrobin".equalsIgnoreCase(strategy)) {
                    urlStrategy = new RoundRobinBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                if ("iphash".equalsIgnoreCase(strategy)) {
                    urlStrategy = new IpHashBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                if ("stickysession".equalsIgnoreCase(strategy)) {
                    urlStrategy = new StickySessionBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                throw new ConfigurationException("No such BaseUrlRetrieveStrategy '" + strategy + "'");
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e);
            }
        }
        return urlStrategy;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getFixMode() {
        return this.fixMode;
    }

    public boolean isFixResources() {
        return this.fixResources;
    }

    public String getVisibleBaseURL(String currentBaseUrl) {
        return this.isVisibleBaseURLEmpty ? currentBaseUrl : this.visibleBaseURL;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public String getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getCookieStore() {
        return this.cookieStore;
    }

    public Collection<String> getParsableContentTypes() {
        return this.parsableContentTypes;
    }

    public BaseUrlRetrieveStrategy getBaseUrlRetrieveStrategy() {
        return this.baseUrlRetrieveStrategy;
    }

    public boolean isForwardedRequestHeader(String headerName) {
        return this.requestHeadersFilterList.contains(headerName);
    }

    public boolean isForwardedResponseHeader(String headerName) {
        return this.responseHeadersFilterList.contains(headerName);
    }
}

