/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.api.HttpRequest;
import org.esigate.http.DateUtils;
import org.esigate.output.Output;
import org.esigate.output.StringOutput;
import org.esigate.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rfc2616 {
    private static final int SECONDS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(Rfc2616.class);

    private Rfc2616() {
    }

    public static final Map<String, String> getVary(Resource resource) {
        String varyString = resource.getHeader("Vary");
        if (varyString != null) {
            String[] varyStringSplit;
            HashMap<String, String> result = new HashMap<String, String>();
            for (String key : varyStringSplit = varyString.split(",")) {
                String value = resource.getRequestHeader(key);
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    public static final Map<String, String> getVary(ResourceContext resourceContext, Resource resource) {
        HttpRequest request = resourceContext.getOriginalRequest();
        String varyString = resource.getHeader("Vary");
        if (varyString != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            String[] varyStringSplit = varyString.split(",");
            for (int i = 0; i < varyStringSplit.length; ++i) {
                String key = varyStringSplit[i];
                String value = request.getHeader(key);
                if (value == null) continue;
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    public static final boolean varyMatches(ResourceContext resourceContext, Resource resource) {
        Map<String, String> vary = Rfc2616.getVary(resource);
        if (vary == null) {
            return true;
        }
        HttpRequest request = resourceContext.getOriginalRequest();
        for (Map.Entry<String, String> header : vary.entrySet()) {
            String key = header.getKey();
            String value = header.getValue();
            if (StringUtils.equals((CharSequence)value, (CharSequence)request.getHeader(key))) continue;
            return false;
        }
        return true;
    }

    public static final boolean needsValidation(ResourceContext resourceContext, Resource resource) {
        if (resource == null) {
            return true;
        }
        return Rfc2616.requiresRefresh(resourceContext) || Rfc2616.isStale(resource);
    }

    public static final boolean isStale(Resource resource) {
        Date date = Rfc2616.getDate(resource);
        Date expiration = Rfc2616.getHeuristicExpiration(resource);
        if (date == null || expiration == null) {
            return true;
        }
        Date nowOnOriginServer = new Date(Rfc2616.getAge(resource) + date.getTime());
        return nowOnOriginServer.after(expiration);
    }

    public static final String getEtag(Resource resource) {
        return resource.getHeader("ETag");
    }

    public static final boolean etagMatches(ResourceContext resourceContext, Resource resource) {
        String etag = Rfc2616.getEtag(resource);
        if (etag == null) {
            return true;
        }
        HttpRequest request = resourceContext.getOriginalRequest();
        String ifNoneMatch = request.getHeader("If-none-match");
        if (ifNoneMatch == null) {
            return true;
        }
        String[] ifNoneMatchSplit = ifNoneMatch.split(",");
        for (int i = 0; i < ifNoneMatchSplit.length; ++i) {
            if (!ifNoneMatchSplit[i].equals(etag)) continue;
            return true;
        }
        return false;
    }

    public static final Date getExpiration(Resource resource) {
        Date date = Rfc2616.getDate(resource);
        Long maxAge = null;
        CacheControlResponseHeader cacheControl = CacheControlResponseHeader.parse(resource);
        if (cacheControl != null) {
            if (cacheControl.maxAge != null) {
                maxAge = cacheControl.maxAge;
            }
            if (cacheControl.sMaxAge != null) {
                maxAge = cacheControl.sMaxAge;
            }
        }
        if (maxAge != null) {
            return new Date(date.getTime() + maxAge * 1000L);
        }
        Date expires = Rfc2616.getDateHeader(resource, "Expires");
        if (expires != null) {
            return expires;
        }
        return null;
    }

    public static final Date getDate(Resource resource) {
        Date date = Rfc2616.getDateHeader(resource, "Date");
        if (date == null) {
            date = Calendar.getInstance().getTime();
        }
        return date;
    }

    public static final Date getHeuristicExpiration(Resource resource) {
        Date expiration = Rfc2616.getExpiration(resource);
        if (expiration != null) {
            return expiration;
        }
        Date date = Rfc2616.getDate(resource);
        if (date == null) {
            return null;
        }
        Date lastModified = Rfc2616.getDateHeader(resource, "Last-modified");
        if (lastModified != null) {
            return new Date(date.getTime() + (date.getTime() - lastModified.getTime()) / 10L);
        }
        return null;
    }

    public static final long getAge(Resource resource) {
        return System.currentTimeMillis() - resource.getLocalDate().getTime();
    }

    public static final boolean isCacheable(Resource resource) {
        CacheControlResponseHeader cacheControl = CacheControlResponseHeader.parse(resource);
        if (cacheControl == null && resource.getHeader("Expires") != null && Rfc2616.getDateHeader(resource, "Expires") == null) {
            return false;
        }
        if (cacheControl._public) {
            return true;
        }
        return !cacheControl._private && !cacheControl.noCache && !cacheControl.noStore && !cacheControl.mustRevalidate && !cacheControl.proxyRevalidate && cacheControl.maxAge > 0L;
    }

    public static final boolean isCacheable(ResourceContext context) {
        String method = context.getOriginalRequest().getMethod();
        return !context.isProxy() || "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    public static final boolean matches(ResourceContext resourceContext, Resource cachedResponse) {
        String method = resourceContext.getOriginalRequest().getMethod();
        if (!"HEAD".equalsIgnoreCase(method) && !cachedResponse.hasResponseBody()) {
            return false;
        }
        if (!Rfc2616.etagMatches(resourceContext, cachedResponse)) {
            return false;
        }
        return Rfc2616.varyMatches(resourceContext, cachedResponse);
    }

    public static final Date getDateHeader(Resource resource, String name) {
        String dateString = resource.getHeader(name);
        return Rfc2616.convertDate(dateString);
    }

    public static final Date getDateHeader(ResourceContext resourceContext, String name) {
        String dateString = resourceContext.getOriginalRequest().getHeader(name);
        return Rfc2616.convertDate(dateString);
    }

    private static final Date convertDate(String dateString) {
        if (dateString != null) {
            try {
                return DateUtils.parseDate(dateString);
            }
            catch (ParseException e) {
                LOG.warn("Invalid date format: " + dateString);
            }
        }
        return null;
    }

    public static final boolean requiresRefresh(ResourceContext context) {
        HttpRequest originalRequest = context.getOriginalRequest();
        String pragma = originalRequest.getHeader("Pragma");
        if ("no-cache".equalsIgnoreCase(pragma)) {
            return true;
        }
        String cacheControl = originalRequest.getHeader("Cache-control");
        return cacheControl != null && ((cacheControl = cacheControl.toLowerCase()).contains("no-cache") || cacheControl.contains("no-store") || cacheControl.contains("must-revalidate") || cacheControl.contains("max-age=0"));
    }

    public static final void renderResource(DriverConfiguration config, Resource resource, Output output) throws IOException, HttpErrorPage {
        if (resource.isError()) {
            StringOutput stringOutput = new StringOutput();
            resource.render(stringOutput);
            String errorPageContent = stringOutput.toString();
            output.setStatusCode(resource.getStatusCode());
            output.setStatusMessage(resource.getStatusMessage());
            Rfc2616.copyHeaders(config, resource, output);
            output.open();
            output.write(errorPageContent);
            output.close();
            throw new HttpErrorPage(resource.getStatusCode(), resource.getStatusMessage(), errorPageContent);
        }
        if (304 == resource.getStatusCode()) {
            output.setStatusCode(resource.getStatusCode());
            output.setStatusMessage(resource.getStatusMessage());
            Rfc2616.copyHeaders(config, resource, output);
            output.open();
            output.getOutputStream();
            output.close();
        } else {
            resource.render(output);
        }
    }

    public static final void copyHeaders(DriverConfiguration config, Resource resource, Output output) {
        for (String headerName : resource.getHeaderNames()) {
            if (!config.isForwardedResponseHeader(headerName)) continue;
            Collection<String> values = resource.getHeaders(headerName);
            for (String value : values) {
                output.addHeader(headerName, value);
            }
        }
    }

    private static final class CacheControlResponseHeader {
        private boolean _public = false;
        private boolean _private = false;
        private boolean noCache = false;
        private boolean noStore = false;
        private boolean mustRevalidate = false;
        private boolean proxyRevalidate = false;
        private Long maxAge = null;
        private Long sMaxAge = null;

        private CacheControlResponseHeader() {
        }

        public static final CacheControlResponseHeader parse(Resource resource) {
            String cacheControlString = resource.getHeader("Cache-control");
            if (cacheControlString == null) {
                return null;
            }
            CacheControlResponseHeader result = new CacheControlResponseHeader();
            String[] split = cacheControlString.split(",");
            for (int i = 0; i < split.length; ++i) {
                String[] token = split[i].trim().split("=");
                if (token[0].equalsIgnoreCase("public")) {
                    result._public = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("private")) {
                    result._private = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("no-cache")) {
                    result.noCache = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("no-store")) {
                    result.noStore = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("must-revalidate")) {
                    result.mustRevalidate = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("proxy-revalidate")) {
                    result.proxyRevalidate = true;
                    continue;
                }
                if (token[0].equalsIgnoreCase("max-age")) {
                    result.maxAge = -1L;
                    if (token.length != 2) continue;
                    try {
                        result.maxAge = Long.parseLong(token[1]);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!token[0].equalsIgnoreCase("s-max-age")) continue;
                result.sMaxAge = -1L;
                if (token.length != 2) continue;
                try {
                    result.sMaxAge = Long.parseLong(token[1]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

