/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.esigate.ConfigurationException;
import org.esigate.DriverConfiguration;
import org.esigate.ResourceFactory;
import org.esigate.http.CachedHttpResourceFactory;
import org.esigate.http.HttpResourceFactory;
import org.esigate.http.RedirectStrategy;

public class ResourceFactoryCreator {
    public static ResourceFactory create(DriverConfiguration config) {
        DefaultHttpClient httpClient = null;
        if (config.getBaseUrlRetrieveStrategy() != null) {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
                Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
                schemeRegistry.register(https);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ConfigurationException(e);
            }
            catch (KeyManagementException e) {
                throw new ConfigurationException(e);
            }
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
            connectionManager.setMaxTotal(config.getMaxConnectionsPerHost());
            connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerHost());
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)config.getConnectTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)config.getSocketTimeout());
            httpParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
            defaultHttpClient.setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
            httpClient = defaultHttpClient;
            if (config.getProxyHost() != null) {
                if (config.getProxyUser() != null) {
                    defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUser(), config.getProxyPassword()));
                }
                HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort(), "http");
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
        ResourceFactory result = new HttpResourceFactory((HttpClient)httpClient);
        if (config.isUseCache()) {
            result = new CachedHttpResourceFactory(result, config);
        }
        return result;
    }

    private ResourceFactoryCreator() {
    }
}

