/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.HashMap;
import org.esigate.ConfigurationException;
import org.esigate.DriverConfiguration;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.cookie.CustomCookieStore;
import org.esigate.extension.Extension;
import org.esigate.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionFactory.class);
    private static final String EXTENSION_WAT_FILTER = Filter.class.getName();
    private static final String EXTENSION_COOKIE_STORE = CustomCookieStore.class.getName();
    private static final String EXTENSION_AUTHENTIFICATION_HANDLER = AuthenticationHandler.class.getName();
    private final HashMap<String, String> classes = new HashMap();
    private final DriverConfiguration conf;

    public ExtensionFactory(DriverConfiguration conf) {
        this.conf = conf;
        this.classes.put(EXTENSION_COOKIE_STORE, conf.getCookieStore());
        this.classes.put(EXTENSION_AUTHENTIFICATION_HANDLER, conf.getAuthenticationHandler());
        this.classes.put(EXTENSION_WAT_FILTER, conf.getFilter());
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        Extension result = null;
        String className = this.classes.get(clazz.getName());
        if (className != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating  " + className + " as " + clazz.getName());
                }
                result = (Extension)Class.forName(className).newInstance();
                result.init(this.conf.getProperties());
            }
            catch (InstantiationException e) {
                throw new ConfigurationException(e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        }
        return (T)result;
    }
}

