/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheStorage
implements CacheStorage {
    private static final Comparator<CacheEntry> CACHE_ENTRY_COMPARATOR = new Comparator<CacheEntry>(){

        @Override
        public int compare(CacheEntry o1, CacheEntry o2) {
            return (int)(o1.getTtl() - o2.getTtl());
        }
    };
    private final Map<String, CacheEntry> cache = Collections.synchronizedMap(new LRUMap());
    private final PriorityQueue<CacheEntry> ttlQueue = new PriorityQueue<CacheEntry>(100, CACHE_ENTRY_COMPARATOR);

    @Override
    public void put(String key, Object value) {
        this.removeExpiredEntries();
        this.cache.put(key, new CacheEntry(value));
    }

    @Override
    public void put(String key, Object value, long ttl) {
        this.removeExpiredEntries();
        CacheEntry cacheEntry = new CacheEntry(value, key, System.currentTimeMillis() + ttl);
        this.ttlQueue.add(cacheEntry);
        this.cache.put(key, cacheEntry);
    }

    @Override
    public Object get(String key) {
        this.removeExpiredEntries();
        CacheEntry cacheEntry = this.cache.get(key);
        return null != cacheEntry ? cacheEntry.getValue() : null;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return clazz.cast(this.get(key));
    }

    @Override
    public void touch(String key) {
        this.get(key);
    }

    @Override
    public void init(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredEntries() {
        if (this.ttlQueue.size() > 0) {
            Map<String, CacheEntry> map = this.cache;
            synchronized (map) {
                boolean needToProcess = true;
                while (needToProcess) {
                    CacheEntry cacheEntry = this.ttlQueue.peek();
                    if (cacheEntry != null && cacheEntry.getTtl() < System.currentTimeMillis()) {
                        this.ttlQueue.remove(cacheEntry);
                        if (!this.cache.containsValue(cacheEntry)) continue;
                        this.cache.remove(cacheEntry.getKey());
                        continue;
                    }
                    needToProcess = false;
                }
            }
        }
    }

    private static class CacheEntry {
        private final Object value;
        private final long ttl;
        private final String key;

        public CacheEntry(Object value) {
            this(value, null, -1L);
        }

        public CacheEntry(Object value, String key, long ttl) {
            this.value = value;
            this.key = key;
            this.ttl = ttl;
        }

        public long getTtl() {
            return this.ttl;
        }

        public Object getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.key).append(this.ttl).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            return new EqualsBuilder().append((Object)this.key, (Object)other.key).append(this.ttl, other.ttl).append(this.value, other.value).isEquals();
        }
    }
}

