/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.esigate.ConfigurationException;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.authentication.RemoteUserAuthenticationHandler;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.DefaultCacheStorage;
import org.esigate.cookie.SerializableBasicCookieStore;
import org.esigate.url.IpHashBaseUrlRetrieveStrategy;
import org.esigate.url.RoundRobinBaseUrlRetrieveStrategy;
import org.esigate.url.SingleBaseUrlRetrieveStrategy;
import org.esigate.url.StickySessionBaseUrlRetrieveStrategy;
import org.esigate.util.FilterList;
import org.esigate.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DriverConfiguration.class);
    private static final String STICKYSESSION = "stickysession";
    private static final String IPHASH = "iphash";
    private static final String ROUNDROBIN = "roundrobin";
    private final String instanceName;
    private String uriEncoding = "ISO-8859-1";
    private boolean fixResources = false;
    private String visibleBaseURL = null;
    private int fixMode = 1;
    private int maxConnectionsPerHost = 20;
    private int connectTimeout = 1000;
    private int socketTimeout = 10000;
    private boolean useCache = true;
    private int cacheRefreshDelay = 0;
    private int cacheMaxFileSize = 0;
    private Class<? extends CacheStorage> cacheStorageClass;
    private final String localBase;
    private boolean putInCache = false;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyPassword = null;
    private boolean filterJsessionid = true;
    private String authenticationHandler = RemoteUserAuthenticationHandler.class.getName();
    private final Properties properties;
    private boolean preserveHost = false;
    private String cookieStore = SerializableBasicCookieStore.class.getName();
    private String filter = null;
    private final List<String> parsableContentTypes;
    private final FilterList requestHeadersFilterList;
    private final FilterList responseHeadersFilterList;
    private final BaseUrlRetrieveStrategy baseUrlRetrieveStrategy;
    private boolean isVisibleBaseURLEmpty = true;
    private static final String DEFAULT_PARSABLE_CONTENT_TYPES = "text/html, application/xhtml+xml";
    private static final String DEFAULT_BLACK_LISTED_REQUEST_HEADERS = "Authorization,Connection,Content-Length,Cookie,Expect,Host,If-Match,If-Modified-Since,If-None-Match,If-Range,If-Unmodified-Since,Max-Forwards,Proxy-Authorization,Range,TE,Trailer,Transfer-Encoding,Upgrade";
    private static final String DEFAULT_BLACK_LISTED_RESPONSE_HEADERS = "Age,Connection,Content-Encoding,Content-Length,Content-Location,Content-MD5,Keep-Alive,Location,Proxy-Authenticate,Set-Cookie,Trailer,Transfer-Encoding,WWW-Authenticate";

    public DriverConfiguration(String instanceName, Properties props) {
        this.instanceName = instanceName;
        this.baseUrlRetrieveStrategy = this.getBaseUrlRetrieveSession(props);
        this.uriEncoding = PropertiesUtil.getPropertyValue(props, "uriEncoding", this.uriEncoding);
        this.maxConnectionsPerHost = PropertiesUtil.getPropertyValue(props, "maxConnectionsPerHost", this.maxConnectionsPerHost);
        int timeout = PropertiesUtil.getPropertyValue(props, "timeout", 1000);
        this.connectTimeout = PropertiesUtil.getPropertyValue(props, "connectTimeout", timeout);
        this.socketTimeout = PropertiesUtil.getPropertyValue(props, "socketTimeout", timeout * 10);
        this.cacheRefreshDelay = PropertiesUtil.getPropertyValue(props, "cacheRefreshDelay", this.cacheRefreshDelay);
        this.cacheMaxFileSize = PropertiesUtil.getPropertyValue(props, "cacheMaxFileSize", this.cacheMaxFileSize);
        if (props.getProperty("cacheStorageClassName") != null) {
            String cacheStorageClassName = props.getProperty("cacheStorageClassName");
            try {
                Class<?> cacheStorageClass = this.getClass().getClassLoader().loadClass(cacheStorageClassName);
                if (cacheStorageClass != null) {
                    this.cacheStorageClass = cacheStorageClass;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cachestorage instance can not be loaded", e);
            }
        }
        if (null == this.cacheStorageClass) {
            this.cacheStorageClass = DefaultCacheStorage.class;
        }
        this.localBase = PropertiesUtil.getPropertyValue(props, "localBase", null);
        this.putInCache = PropertiesUtil.getPropertyValue(props, "putInCache", this.putInCache);
        if (props.getProperty("proxyHost") != null && props.getProperty("proxyPort") != null) {
            this.proxyHost = PropertiesUtil.getPropertyValue(props, "proxyHost", null);
            this.proxyPort = PropertiesUtil.getPropertyValue(props, "proxyPort", 0);
            if (props.getProperty("proxyUser") != null && props.getProperty("proxyPassword") != null) {
                this.proxyUser = PropertiesUtil.getPropertyValue(props, "proxyUser", null);
                this.proxyPassword = PropertiesUtil.getPropertyValue(props, "proxyPassword", null);
            }
        }
        this.useCache = PropertiesUtil.getPropertyValue(props, "useCache", this.useCache);
        this.filterJsessionid = PropertiesUtil.getPropertyValue(props, "filterJsessionid", this.filterJsessionid);
        this.authenticationHandler = PropertiesUtil.getPropertyValue(props, "authenticationHandler", this.authenticationHandler);
        this.cookieStore = PropertiesUtil.getPropertyValue(props, "cookieStore", this.cookieStore);
        this.filter = PropertiesUtil.getPropertyValue(props, "filter", this.filter);
        this.preserveHost = PropertiesUtil.getPropertyValue(props, "preserveHost", this.preserveHost);
        if (props.getProperty("fixResources") != null) {
            this.fixResources = PropertiesUtil.getPropertyValue(props, "fixResources", this.fixResources);
            if (props.getProperty("fixMode") != null && "absolute".equalsIgnoreCase(props.getProperty("fixMode"))) {
                this.fixMode = 0;
            }
            this.visibleBaseURL = PropertiesUtil.getPropertyValue(props, "visibleUrlBase", null);
            this.isVisibleBaseURLEmpty = StringUtils.isEmpty((CharSequence)this.visibleBaseURL);
        }
        String strContentTypes = PropertiesUtil.getPropertyValue(props, "parsableContentTypes", DEFAULT_PARSABLE_CONTENT_TYPES);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        this.parsableContentTypes = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
        this.requestHeadersFilterList = new FilterList();
        this.responseHeadersFilterList = new FilterList();
        this.requestHeadersFilterList.add(Collections.singletonList("*"));
        this.responseHeadersFilterList.add(Collections.singletonList("*"));
        if (props.get("blackListedHeaders") != null) {
            LOG.warn("Property 'blackListedHeaders' is deprecated");
            Collection<String> blackListedHeadersList = PropertiesUtil.getPropertyValueAsList(props, "blackListedHeaders");
            this.requestHeadersFilterList.remove(blackListedHeadersList);
            this.responseHeadersFilterList.remove(blackListedHeadersList);
        }
        PropertiesUtil.populate(this.requestHeadersFilterList, props, "forwardRequestHeaders", "discardRequestHeaders", "", DEFAULT_BLACK_LISTED_REQUEST_HEADERS);
        PropertiesUtil.populate(this.responseHeadersFilterList, props, "forwardResponseHeaders", "discardResponseHeaders", "", DEFAULT_BLACK_LISTED_RESPONSE_HEADERS);
        this.properties = props;
    }

    private BaseUrlRetrieveStrategy getBaseUrlRetrieveSession(Properties props) {
        BaseUrlRetrieveStrategy urlStrategy;
        block7: {
            urlStrategy = null;
            String baseURLs = PropertiesUtil.getPropertyValue(props, "remoteUrlBase", null);
            try {
                if (StringUtils.isEmpty((CharSequence)baseURLs)) break block7;
                String[] urls = StringUtils.split((String)baseURLs, (String)",");
                if (1 == urls.length) {
                    String baseURL = StringUtils.trimToEmpty((String)urls[0]);
                    new URL(baseURL);
                    urlStrategy = new SingleBaseUrlRetrieveStrategy(baseURL);
                    break block7;
                }
                if (urls.length <= 0) break block7;
                String[] urlArr = new String[urls.length];
                for (int i = 0; i < urls.length; ++i) {
                    String baseURL = StringUtils.trimToEmpty((String)urls[i]);
                    new URL(baseURL);
                    urlArr[i] = baseURL;
                }
                String strategy = StringUtils.trimToEmpty((String)PropertiesUtil.getPropertyValue(props, "remoteUrlBaseStrategy", ROUNDROBIN));
                if (ROUNDROBIN.equalsIgnoreCase(strategy)) {
                    urlStrategy = new RoundRobinBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                if (IPHASH.equalsIgnoreCase(strategy)) {
                    urlStrategy = new IpHashBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                if (STICKYSESSION.equalsIgnoreCase(strategy)) {
                    urlStrategy = new StickySessionBaseUrlRetrieveStrategy(urlArr);
                    break block7;
                }
                throw new ConfigurationException("No such BaseUrlRetrieveStrategy '" + strategy + "'");
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e);
            }
        }
        return urlStrategy;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getFixMode() {
        return this.fixMode;
    }

    public boolean isFixResources() {
        return this.fixResources;
    }

    public String getVisibleBaseURL(String currentBaseUrl) {
        return this.isVisibleBaseURLEmpty ? currentBaseUrl : this.visibleBaseURL;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public int getCacheRefreshDelay() {
        return this.cacheRefreshDelay;
    }

    public int getCacheMaxFileSize() {
        return this.cacheMaxFileSize;
    }

    public String getLocalBase() {
        return this.localBase;
    }

    public boolean isPutInCache() {
        return this.putInCache;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public boolean isFilterJsessionid() {
        return this.filterJsessionid;
    }

    public String getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setCookieStore(String cookieStore) {
        this.cookieStore = cookieStore;
    }

    public String getCookieStore() {
        return this.cookieStore;
    }

    public Class<? extends CacheStorage> getCacheStorageClass() {
        return this.cacheStorageClass;
    }

    public Collection<String> getParsableContentTypes() {
        return this.parsableContentTypes;
    }

    public BaseUrlRetrieveStrategy getBaseUrlRetrieveStrategy() {
        return this.baseUrlRetrieveStrategy;
    }

    public boolean isForwardedRequestHeader(String headerName) {
        return this.requestHeadersFilterList.contains(headerName);
    }

    public boolean isForwardedResponseHeader(String headerName) {
        return this.responseHeadersFilterList.contains(headerName);
    }
}

