/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.ResourceContext;
import org.esigate.ResourceFactory;
import org.esigate.ResponseOutput;
import org.esigate.ResponseOutputStreamException;
import org.esigate.UserContext;
import org.esigate.api.HttpRequest;
import org.esigate.api.HttpResponse;
import org.esigate.api.HttpSession;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.cookie.CustomCookieStore;
import org.esigate.extension.ExtensionFactory;
import org.esigate.filter.Filter;
import org.esigate.http.ResourceFactoryCreator;
import org.esigate.output.Output;
import org.esigate.output.StringOutput;
import org.esigate.output.TextOnlyStringOutput;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.renderers.ResourceFixupRenderer;
import org.esigate.resource.Resource;
import org.esigate.resource.ResourceUtils;
import org.esigate.tags.BlockRenderer;
import org.esigate.tags.TemplateRenderer;
import org.esigate.util.Rfc2616;
import org.esigate.vars.VariablesResolver;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private final DriverConfiguration config;
    private final AuthenticationHandler authenticationHandler;
    private final Filter filter;
    private final ResourceFactory resourceFactory;
    private final ExtensionFactory extension;

    public Driver(String name, Properties props) {
        LOG.info("Initializing instance: " + name);
        this.config = new DriverConfiguration(name, props);
        this.resourceFactory = ResourceFactoryCreator.create(this.config);
        this.extension = new ExtensionFactory(this.config);
        this.authenticationHandler = this.extension.getExtension(AuthenticationHandler.class);
        Filter f = this.extension.getExtension(Filter.class);
        this.filter = f != null ? f : Filter.EMPTY;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public final UserContext getUserContext(HttpRequest request) {
        String key = this.getContextKey();
        UserContext context = (UserContext)request.getAttribute(key);
        if (context == null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                context = (UserContext)session.getAttribute(key);
            }
            if (context == null) {
                context = this.createNewUserContext();
            }
            request.setAttribute(key, context);
        }
        return context;
    }

    private UserContext createNewUserContext() {
        UserContext context = new UserContext(this.extension.getExtension(CustomCookieStore.class));
        return context;
    }

    public final void saveUserContext(HttpRequest request) {
        HttpSession session;
        Object sessionContext;
        String key = this.getContextKey();
        UserContext context = (UserContext)request.getAttribute(key);
        if (!(context == null || context.isEmpty() || (sessionContext = (session = request.getSession(true)).getAttribute(key)) != null && sessionContext == context)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Provider=" + this.config.getInstanceName() + " saving context to session : " + context.toString().replaceAll("\n", ""));
            }
            session.setAttribute(key, context);
        }
    }

    public final void renderXml(String source, String template, Appendable out, HttpRequest request, HttpResponse response, Map<String, String> replaceRules) throws IOException, HttpErrorPage {
        LOG.info("renderXml provider=" + this.config.getInstanceName() + " source=" + source + " template=" + template);
        this.render(source, null, out, request, response, new XsltRenderer(template, request), new ReplaceRenderer(replaceRules));
    }

    public final void renderXpath(String source, String xpath, Appendable out, HttpRequest request, HttpResponse response, Map<String, String> replaceRules) throws IOException, HttpErrorPage {
        LOG.info("renderXpath provider=" + this.config.getInstanceName() + " source=" + source + " xpath=" + xpath);
        this.render(source, null, out, request, response, new XpathRenderer(xpath), new ReplaceRenderer(replaceRules));
    }

    public final ResourceContext renderBlock(String page, String name, Appendable writer, HttpRequest request, HttpResponse response, Map<String, String> replaceRules, Map<String, String> parameters, boolean copyOriginalRequestParameters) throws IOException, HttpErrorPage {
        LOG.info("renderBlock provider=" + this.config.getInstanceName() + " page=" + page + " name=" + name);
        return this.render(page, parameters, writer, request, response, new BlockRenderer(name, page), new ReplaceRenderer(replaceRules));
    }

    public final void renderTemplate(String page, String name, Appendable writer, HttpRequest request, HttpResponse response, Map<String, String> params, Map<String, String> replaceRules, Map<String, String> parameters, boolean propagateJsessionId) throws IOException, HttpErrorPage {
        LOG.info("renderTemplate provider=" + this.config.getInstanceName() + " page=" + page + " name=" + name);
        this.render(page, parameters, writer, request, response, new TemplateRenderer(name, params, page), new ReplaceRenderer(replaceRules));
    }

    public final void renderEsi(String page, Appendable writer, HttpRequest request, HttpResponse response) throws IOException, HttpErrorPage {
        this.render(page, null, writer, request, response, new Renderer[0]);
    }

    public final void render(String page, Appendable writer, ResourceContext parent, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.render(page, parent.getParameters(), writer, parent.getOriginalRequest(), parent.getOriginalResponse(), renderers);
    }

    protected final ResourceContext render(String page, Map<String, String> parameters, Appendable writer, HttpRequest request, HttpResponse response, Renderer ... renderers) throws IOException, HttpErrorPage {
        if (LOG.isInfoEnabled()) {
            ArrayList<String> rendererNames = new ArrayList<String>(renderers.length);
            for (Renderer renderer : renderers) {
                rendererNames.add(renderer.getClass().getName());
            }
            LOG.info("render provider={} page= {} renderers={}", new Object[]{this.config.getInstanceName(), page, rendererNames});
        }
        String resultingpage = VariablesResolver.replaceAllVariables(page, request);
        ResourceContext resourceContext = new ResourceContext(this, resultingpage, parameters, request, response);
        resourceContext.setPreserveHost(this.config.isPreserveHost());
        StringOutput stringOutput = this.getResourceAsString(resourceContext);
        String currentValue = stringOutput.toString();
        if (this.config.isFixResources()) {
            ResourceFixupRenderer fixup = new ResourceFixupRenderer(resourceContext.getBaseURL(), this.config.getVisibleBaseURL(resourceContext.getBaseURL()), page, this.config.getFixMode());
            StringWriter stringWriter = new StringWriter();
            fixup.render(resourceContext, currentValue, stringWriter);
            currentValue = stringWriter.toString();
        }
        for (Renderer renderer : renderers) {
            StringWriter stringWriter = new StringWriter();
            renderer.render(resourceContext, currentValue, stringWriter);
            currentValue = stringWriter.toString();
        }
        writer.append(currentValue);
        return resourceContext;
    }

    public final void proxy(String relUrl, HttpRequest request, HttpResponse response, Renderer ... renderers) throws IOException, HttpErrorPage {
        LOG.info("proxy provider={} relUrl={}", (Object)this.config.getInstanceName(), (Object)relUrl);
        ResourceContext resourceContext = new ResourceContext(this, relUrl, null, request, response);
        request.setCharacterEncoding(this.config.getUriEncoding());
        resourceContext.setProxy(true);
        resourceContext.setPreserveHost(this.config.isPreserveHost());
        if (!this.authenticationHandler.beforeProxy(resourceContext)) {
            return;
        }
        if (renderers.length == 0 && !this.config.isFixResources()) {
            resourceContext.setNeededForTransformation(false);
            this.renderResource(resourceContext, new ResponseOutput(response));
        } else {
            TextOnlyStringOutput textOutput = new TextOnlyStringOutput(response, this.config.getParsableContentTypes());
            this.renderResource(resourceContext, textOutput);
            if (!textOutput.hasTextBuffer()) {
                LOG.debug("'" + relUrl + "' is binary : was forwarded without modification.");
                return;
            }
            LOG.debug("'" + relUrl + "' is text : will apply renderers.");
            String currentValue = textOutput.toString();
            ArrayList<Renderer> listOfRenderers = new ArrayList<Renderer>(renderers.length + 1);
            if (this.config.isFixResources()) {
                ResourceFixupRenderer fixup = new ResourceFixupRenderer(resourceContext.getBaseURL(), this.config.getVisibleBaseURL(resourceContext.getBaseURL()), relUrl, this.config.getFixMode());
                listOfRenderers.add(fixup);
            }
            listOfRenderers.addAll(Arrays.asList(renderers));
            for (Renderer renderer : listOfRenderers) {
                StringWriter stringWriter = new StringWriter();
                renderer.render(resourceContext, currentValue, stringWriter);
                currentValue = stringWriter.toString();
            }
            String charsetName = textOutput.getCharsetName();
            if (charsetName == null) {
                charsetName = "ISO-8859-1";
                response.getOutputStream().write(currentValue.getBytes(charsetName));
            } else {
                response.setCharacterEncoding(charsetName);
                response.getWriter().write(currentValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderResource(ResourceContext resourceContext, Output output) throws HttpErrorPage {
        Resource resource = null;
        try {
            resource = this.resourceFactory.getResource(resourceContext);
            try {
                Rfc2616.renderResource(this.config, resource, output);
            }
            catch (ResponseOutputStreamException e) {
                if (LOG.isInfoEnabled()) {
                    Throwable t = e.getCause();
                    LOG.info("Client or network problem, ignoring: {} {}", (Object)t.getClass().getName(), (Object)t.getMessage());
                }
            }
            catch (IOException e) {
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter(out));
                HttpErrorPage httpErrorPage = new HttpErrorPage(502, e.getMessage(), out.toString());
                httpErrorPage.initCause(e);
                throw httpErrorPage;
            }
        }
        finally {
            if (null != resource) {
                resource.release();
            }
        }
    }

    protected StringOutput getResourceAsString(ResourceContext target) throws HttpErrorPage {
        StringOutput result = null;
        String url = ResourceUtils.getHttpUrlWithQueryString(target);
        HttpRequest request = target.getOriginalRequest();
        boolean cacheable = Rfc2616.isCacheable(target);
        if (cacheable) {
            result = (StringOutput)request.getAttribute(url);
        }
        if (result == null) {
            result = new StringOutput();
            this.renderResource(target, result);
            if (cacheable) {
                request.setAttribute(url, result);
            }
        }
        return result;
    }

    public String getResourceAsString(String page, ResourceContext ctx) throws HttpErrorPage {
        String actualPage = VariablesResolver.replaceAllVariables(page, ctx.getOriginalRequest());
        ResourceContext resourceContext = new ResourceContext(this, actualPage, null, ctx.getOriginalRequest(), ctx.getOriginalResponse());
        resourceContext.setPreserveHost(this.getConfiguration().isPreserveHost());
        StringOutput stringOutput = this.getResourceAsString(resourceContext);
        String currentValue = stringOutput.toString();
        return currentValue;
    }

    private final String getContextKey() {
        return UserContext.class.getName() + "#" + this.config.getInstanceName();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public DriverConfiguration getConfiguration() {
        return this.config;
    }
}

