/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    private final Pattern pattern;
    private final ElementType[] elementTypes;
    private ResourceContext resourceContext;

    public Parser(Pattern pattern, ElementType ... elementTypes) {
        this.pattern = pattern;
        this.elementTypes = elementTypes;
    }

    public void parse(CharSequence in, Appendable out) throws IOException, HttpErrorPage {
        ParserContextImpl ctx = new ParserContextImpl(out, this.resourceContext);
        Matcher matcher = this.pattern.matcher(in);
        int currentPosition = 0;
        while (matcher.find()) {
            String tag = matcher.group();
            ctx.characters(in, currentPosition, matcher.start());
            currentPosition = matcher.end();
            if (ctx.isCurrentTagEnd(tag)) {
                LOG.info("Processing end tag " + tag);
                ctx.endElement(tag);
                continue;
            }
            LOG.info("Processing start tag " + tag);
            ElementType type = null;
            for (ElementType t : this.elementTypes) {
                if (!t.isStartTag(tag)) continue;
                type = t;
                break;
            }
            if (type != null) {
                Element element = type.newInstance();
                ctx.startElement(type, element, tag);
                if (!element.isClosed()) continue;
                ctx.endElement(tag);
                continue;
            }
            ctx.characters(tag);
        }
        ctx.characters(in, currentPosition, in.length());
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
    }
}

