/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.esigate.cookie.BasicClientCookie;
import org.esigate.cookie.CustomCookieStore;

class CookieAdapter {
    CookieAdapter() {
    }

    public static CookieStore convertCookieStore(CustomCookieStore customStore) {
        return new Adapter(customStore);
    }

    public static Cookie toApacheCookie(org.esigate.api.Cookie cookie) {
        BasicClientCookie2 newCookie = new BasicClientCookie2(cookie.getName(), cookie.getValue());
        newCookie.setComment(cookie.getComment());
        newCookie.setCommentURL(cookie.getCommentURL());
        newCookie.setDomain(cookie.getDomain());
        newCookie.setExpiryDate(cookie.getExpiryDate());
        newCookie.setPath(cookie.getPath());
        newCookie.setPorts(cookie.getPorts());
        newCookie.setSecure(cookie.isSecure());
        newCookie.setVersion(cookie.getVersion());
        return newCookie;
    }

    public static org.esigate.api.Cookie toCustomCookie(Cookie cookie) {
        BasicClientCookie newCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        newCookie.setComment(cookie.getComment());
        newCookie.setCommentURL(cookie.getCommentURL());
        newCookie.setDomain(cookie.getDomain());
        newCookie.setExpiryDate(cookie.getExpiryDate());
        newCookie.setPath(cookie.getPath());
        newCookie.setPorts(cookie.getPorts());
        newCookie.setSecure(cookie.isSecure());
        newCookie.setVersion(cookie.getVersion());
        return newCookie;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Adapter
    implements CookieStore {
        private final CustomCookieStore customStore;

        private Adapter(CustomCookieStore customStore) {
            this.customStore = customStore;
        }

        public void addCookie(Cookie cookie) {
            this.customStore.addCookie(CookieAdapter.toCustomCookie(cookie));
        }

        public List<Cookie> getCookies() {
            List<org.esigate.api.Cookie> customCookieList = this.customStore.getCookies();
            ArrayList<Cookie> cookiesList = new ArrayList<Cookie>(customCookieList.size());
            for (org.esigate.api.Cookie cookie : customCookieList) {
                cookiesList.add(CookieAdapter.toApacheCookie(cookie));
            }
            return cookiesList;
        }

        public boolean clearExpired(Date date) {
            return this.customStore.clearExpired(date);
        }

        public void clear() {
            this.customStore.clear();
        }
    }
}

