/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.file;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeadersFile {
    private final Map<String, Set<String>> headers;
    private int statusCode;
    private String statusMessage;

    public HeadersFile() {
        this(0, null);
    }

    public HeadersFile(int statusCode, String statusMessage) {
        this(new HashMap<String, Set<String>>(), statusCode, statusMessage);
    }

    public HeadersFile(Map<String, Set<String>> headers, int statusCode, String statusMessage) {
        this.headers = headers;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public void addHeader(String name, String value) {
        Set<String> values = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            values = entry.getValue();
            break;
        }
        if (values == null) {
            values = new TreeSet<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public String getHeader(String key) {
        String result = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey()) || entry.getValue().isEmpty()) continue;
            result = entry.getValue().iterator().next();
            break;
        }
        return result;
    }

    public Collection<String> getHeaders(String key) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            result.addAll((Collection<String>)entry.getValue());
            break;
        }
        return result;
    }

    public Map<String, Set<String>> getHeadersMap() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }
}

