/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.util.Map;
import org.esigate.HttpErrorPage;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FragmentReplacementElement
extends BaseElement {
    private final Map<String, CharSequence> replacements;
    private String currentReplacement;

    public static ElementType createType(final Map<String, CharSequence> replacements) {
        return new BaseElementType("<esi:fragment", "</esi:fragment"){

            public FragmentReplacementElement newInstance() {
                return new FragmentReplacementElement(replacements);
            }
        };
    }

    FragmentReplacementElement(Map<String, CharSequence> replacements) {
        this.replacements = replacements;
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) throws IOException {
        this.characters(tag, 0, tag.length());
        this.currentReplacement = null;
    }

    @Override
    public void onTagStart(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        super.onTagStart(tag, ctx);
        Tag tagObj = Tag.create(tag);
        String name = tagObj.getAttribute("name");
        if (this.replacements.containsKey(name)) {
            this.currentReplacement = name;
            CharSequence replacementBody = this.replacements.get(name);
            super.characters(replacementBody, 0, replacementBody.length());
        } else if (!tagObj.isOpenClosed()) {
            this.currentReplacement = null;
            super.characters(tag, 0, tag.length());
        }
    }

    @Override
    public void characters(CharSequence csq, int start, int end) throws IOException {
        if (this.currentReplacement == null) {
            super.characters(csq, start, end);
        }
    }
}

