/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.esigate.cache.BaseCachedResource;
import org.esigate.output.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedResponseSummary
extends BaseCachedResource {
    private static final long serialVersionUID = 5229420665779140066L;
    private final String cacheKey;
    private Map<String, String> requestHeaders;
    private boolean responseBody;
    private Date localDate;

    public CachedResponseSummary(String cacheKey, Map<String, Set<String>> headers, int statusCode, String statusMessage) {
        super(headers, statusCode, statusMessage);
        this.cacheKey = cacheKey;
        this.requestHeaders = new HashMap<String, String>();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cacheKey).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachedResponseSummary)) {
            return false;
        }
        CachedResponseSummary other = (CachedResponseSummary)obj;
        return new EqualsBuilder().append((Object)this.cacheKey, (Object)other.cacheKey).isEquals();
    }

    @Override
    public Date getLocalDate() {
        return this.localDate;
    }

    public void setLocalDate(Date localDate) {
        this.localDate = localDate;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public boolean hasResponseBody() {
        return this.responseBody;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setResponseBody(boolean responseBody) {
        this.responseBody = responseBody;
    }

    @Override
    public void release() {
    }

    @Override
    public void render(Output output) throws IOException {
        throw new IOException("CachedResponseSummary cannot be rendered");
    }

    @Override
    public String getRequestHeader(String key) {
        for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String toString() {
        return this.cacheKey;
    }
}

