/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.esigate.cache.CachedResponse;
import org.esigate.output.Output;
import org.esigate.output.OutputException;

public class CacheOutput
extends Output {
    private final MaxSizedOutputStream out;

    public CacheOutput(int maxSize) {
        this.out = new MaxSizedOutputStream(maxSize);
    }

    public void open() {
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
    }

    public CachedResponse toResource() {
        CachedResponse result = this.out.isTooBig() ? null : new CachedResponse(this.out.toByteArray(), this.getCharsetName(), this.getHeaders(), this.getStatusCode(), this.getStatusMessage());
        this.out.clear();
        return result;
    }

    public static final class MaxSizedOutputStream
    extends ByteArrayOutputStream {
        private final int maxSize;
        private boolean tooBig = false;

        public MaxSizedOutputStream(int maxSize) {
            this.maxSize = maxSize;
        }

        public synchronized void write(int b) {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        public synchronized void write(byte[] b, int off, int len) {
            if (!this.tooBig) {
                if (this.maxSize != 0 && this.count + len > this.maxSize) {
                    this.tooBig = true;
                } else {
                    super.write(b, off, len);
                }
            }
        }

        public synchronized boolean isTooBig() {
            return this.tooBig;
        }

        public void clear() {
            this.count = 0;
            this.buf = new byte[32];
        }
    }
}

