/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Map;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.cache.CacheEntry;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.CachedResponse;
import org.esigate.resource.Resource;
import org.esigate.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache {
    private static Logger LOG = LoggerFactory.getLogger(Cache.class);
    private CacheStorage storage;

    private CacheEntry getCacheEntry(ResourceContext resourceContext) {
        CacheEntry cacheEntry;
        String host;
        String key = ResourceUtils.getHttpUrlWithQueryString(resourceContext);
        if (resourceContext.getDriver().getConfiguration().isPreserveHost() && (host = resourceContext.getOriginalRequest().getHeader("Host")) != null) {
            key = host + "=>" + key;
        }
        if ((cacheEntry = this.storage.get(key, CacheEntry.class)) == null) {
            cacheEntry = new CacheEntry(key, this.storage);
            this.putToStorage(cacheEntry, resourceContext);
        } else {
            cacheEntry.setStorage(this.storage);
        }
        return cacheEntry;
    }

    public CachedResponse get(ResourceContext resourceContext) {
        CacheEntry entry = this.getCacheEntry(resourceContext);
        CachedResponse reponse = entry.get(resourceContext);
        if (entry.isDirty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CacheEntry was updated during get. Updating cache");
            }
            entry.setDirty(false);
            this.putToStorage(entry, resourceContext);
        }
        return reponse;
    }

    public Map<String, String> getValidators(ResourceContext resourceContext, CachedResponse cachedResponse) {
        return this.getCacheEntry(resourceContext).getValidators(resourceContext, cachedResponse);
    }

    public Resource select(ResourceContext resourceContext, CachedResponse oldResponse, Resource newResponse) throws HttpErrorPage {
        CacheEntry entry = this.getCacheEntry(resourceContext);
        Resource resource = entry.select(resourceContext, oldResponse, newResponse);
        if (entry.isDirty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CacheEntry was updated during get. Updating cache");
            }
            entry.setDirty(false);
            this.putToStorage(entry, resourceContext);
        }
        return resource;
    }

    public void put(ResourceContext resourceContext, CachedResponse resource) {
        CacheEntry entry = this.getCacheEntry(resourceContext);
        entry.put(resourceContext, resource);
        entry.setDirty(false);
        this.putToStorage(entry, resourceContext);
    }

    public void setStorage(CacheStorage storage) {
        this.storage = storage;
    }

    private void putToStorage(CacheEntry entry, ResourceContext resourceContext) {
        boolean noStore = resourceContext.getOriginalRequest().isNoStoreResource();
        if (!noStore) {
            Long ttl = resourceContext.getOriginalRequest().getResourceTtl();
            if (ttl == null) {
                this.storage.put(entry.getUrl(), entry);
            } else {
                this.storage.put(entry.getUrl(), entry, ttl);
            }
        }
    }
}

