/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.esigate.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseCachedResource
extends Resource
implements Serializable {
    private static final long serialVersionUID = 1771883783632694287L;
    protected final Map<String, Set<String>> headers;
    protected final int statusCode;
    protected final String statusMessage;

    protected BaseCachedResource(Map<String, Set<String>> headers, int statusCode, String statusMessage) {
        this.headers = headers;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public String getHeader(String key) {
        String result = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey()) || entry.getValue().isEmpty()) continue;
            result = entry.getValue().iterator().next();
            break;
        }
        return result;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            result.addAll((Collection<String>)entry.getValue());
            break;
        }
        return result;
    }

    public void addHeader(String name, String value) {
        Set<String> values = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            values = entry.getValue();
            break;
        }
        if (values == null) {
            values = new TreeSet<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }
}

