/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.authentication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.esigate.ResourceContext;
import org.esigate.api.HttpSession;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.http.HttpClientRequest;
import org.esigate.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticationHandler.class);
    private final List<String> sessionAttributes = new ArrayList<String>();
    private final List<String> requestAttributes = new ArrayList<String>();
    private String headerPrefix = "X-ATTR-";

    public boolean beforeProxy(ResourceContext requestContext) throws IOException {
        return true;
    }

    public void init(Properties properties) {
        String headerPrefixProperty;
        String requestAttributesProperty;
        String sessionAttributesProperty = properties.getProperty("forwardSessionAttributes");
        if (sessionAttributesProperty != null) {
            String[] attributes;
            for (String attribute : attributes = sessionAttributesProperty.split(",")) {
                this.sessionAttributes.add(attribute.trim());
                if (!logger.isInfoEnabled()) continue;
                logger.info("Forwading session attribute: " + attribute);
            }
        }
        if ((requestAttributesProperty = (String)properties.get("forwardRequestAttributes")) != null) {
            String[] attributes;
            for (String attribute : attributes = requestAttributesProperty.split(",")) {
                this.requestAttributes.add(attribute.trim());
                if (!logger.isInfoEnabled()) continue;
                logger.info("Forwading request attribute: " + attribute);
            }
        }
        if ((headerPrefixProperty = (String)properties.get("headerPrefix")) != null) {
            this.headerPrefix = headerPrefixProperty;
        }
    }

    public boolean needsNewRequest(HttpClientResponse response, ResourceContext requestContext) {
        return false;
    }

    public void preRequest(HttpClientRequest request, ResourceContext requestContext) {
        String value;
        HttpSession session;
        if (logger.isDebugEnabled()) {
            logger.debug("preRequest");
        }
        if ((session = requestContext.getOriginalRequest().getSession(false)) != null) {
            for (String attribute : this.sessionAttributes) {
                value = (String)session.getAttribute(attribute);
                if (value == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding session attribute " + attribute + " (" + value + ") as header (" + this.headerPrefix + attribute + ")");
                }
                request.addHeader(this.headerPrefix + attribute, value);
            }
        }
        for (String attribute : this.requestAttributes) {
            value = (String)requestContext.getOriginalRequest().getAttribute(attribute);
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding request attribute " + attribute + " (" + value + ") as header (" + this.headerPrefix + attribute + ")");
            }
            request.addHeader(this.headerPrefix + attribute, value);
        }
    }
}

