/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.esigate.ResponseOutputStream;
import org.esigate.api.HttpResponse;
import org.esigate.output.Output;
import org.esigate.output.OutputException;

class ResponseOutput
extends Output {
    private final HttpResponse response;
    private OutputStream outputStream;

    public ResponseOutput(HttpResponse response) {
        this.response = response;
    }

    public void open() {
        this.response.setStatus(this.getStatusCode());
        try {
            this.copyHeaders();
            this.outputStream = new ResponseOutputStream(this.response.getOutputStream());
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void copyHeaders() {
        for (Map.Entry<String, Set<String>> entry : this.getHeaders().entrySet()) {
            Set<String> values = entry.getValue();
            for (String value : values) {
                this.response.addHeader(entry.getKey(), value);
            }
        }
    }

    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new OutputException(e);
            }
        }
    }
}

