/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.vars;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.api.Cookie;
import org.esigate.api.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesResolver {
    private static final Logger LOG = LoggerFactory.getLogger(VariablesResolver.class);
    private static Properties properties;
    private static Pattern VAR_PATTERN;

    private VariablesResolver() {
    }

    public static final void configure() {
        InputStream inputStream = null;
        try {
            LOG.debug("Loading vars.properties file {}", (Object)Driver.class.getResource("vars.properties"));
            inputStream = Driver.class.getResourceAsStream("vars.properties");
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static boolean containsVariable(String strVars) {
        return strVars.contains("$(") && strVars.contains(")");
    }

    public static String replaceAllVariables(String strVars) {
        return VariablesResolver.replaceAllVariables(strVars, null);
    }

    public static String replaceAllVariables(String strVars, HttpRequest request) {
        String result = strVars;
        if (VariablesResolver.containsVariable(strVars)) {
            Matcher matcher = VAR_PATTERN.matcher(strVars);
            while (matcher.find()) {
                String value;
                String group = matcher.group();
                String var = group.substring(2, group.length() - 1);
                String arg = null;
                try {
                    arg = var.substring(var.indexOf(123) + 1, var.indexOf(125));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if ((value = VariablesResolver.getProperty(var, arg, request)) == null) continue;
                result = result.replace(group, value);
            }
        }
        return result;
    }

    private static String getProperty(String var, String arg, HttpRequest request) {
        String result = VariablesResolver.processVar(var, arg, request);
        if (properties != null) {
            result = properties.getProperty(var, result);
        }
        LOG.debug("Resolve property $(" + var + ")=" + result);
        return result;
    }

    private static String processVar(String var, String arg, HttpRequest request) {
        String res = null;
        if (var.indexOf("QUERY_STRING") != -1) {
            res = arg == null ? request.getQueryString() : request.getParameter(arg);
        } else if (var.indexOf("HTTP_ACCEPT_LANGUAGE") != -1) {
            String langs = request.getHeader("Accept-Language");
            res = arg == null ? langs : (langs.indexOf(arg) == -1 ? "false" : "true");
        } else if (var.indexOf("HTTP_HOST") != -1) {
            res = request.getHeader("Host");
        } else if (var.indexOf("HTTP_REFERER") != -1) {
            res = request.getHeader("Referer");
        } else if (var.indexOf("HTTP_COOKIE") != -1) {
            if (arg == null) {
                res = request.getHeader("Cookies");
            } else {
                Cookie[] cookies;
                for (Cookie c : cookies = request.getCookies()) {
                    if (!c.getName().equals(arg)) continue;
                    res = c.getValue();
                    break;
                }
            }
        } else if (var.indexOf("HTTP_USER_AGENT") != -1) {
            if (arg == null) {
                res = request.getHeader("User-agent");
            } else {
                String userAgent = request.getHeader("User-Agent").toLowerCase();
                if (arg.equals("os")) {
                    res = userAgent.indexOf("unix") != -1 ? "UNIX" : (userAgent.indexOf("mac") != -1 ? "MAC" : (userAgent.indexOf("windows") != -1 ? "WIN" : "OTHER"));
                } else if (arg.equals("browser")) {
                    res = userAgent.indexOf("msie") != -1 ? "MSIE" : "MOZILLA";
                }
            }
        }
        return res;
    }

    static {
        VariablesResolver.configure();
        VAR_PATTERN = Pattern.compile("\\$\\((.*?)\\)");
    }
}

