/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.servlet.HttpRequestImpl;
import org.esigate.servlet.HttpResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private String provider;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relUrl = request.getRequestURI();
        relUrl = relUrl.substring(request.getContextPath().length());
        if (request.getServletPath() != null) {
            relUrl = relUrl.substring(request.getServletPath().length());
        }
        LOG.debug("Proxying " + relUrl);
        try {
            DriverFactory.getInstance(this.provider).proxy(relUrl, HttpRequestImpl.wrap(request), HttpResponseImpl.wrap(response), new Renderer[0]);
        }
        catch (HttpErrorPage e) {
            response.setStatus(e.getStatusCode());
            response.getWriter().write(e.getErrorPageContent());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.provider = config.getInitParameter("provider");
    }
}

