/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.esigate.http.HttpClientResponse;
import org.esigate.http.UnsupportedHttpMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequest.class);
    private String uri;
    private final org.esigate.api.HttpRequest originalRequest;
    private final boolean proxy;
    private BasicHttpRequest httpRequest;
    private HashMap<String, String> headers;
    private boolean preserveHost = false;
    private CookieStore cookieStore;
    private static final String[] UNSAFE = new String[]{"{", "}", "|", "\\", "^", "~", "[", "]", "`"};
    private static final String[] ESCAPED = new String[]{"%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60"};

    public HttpClientRequest(String uri, org.esigate.api.HttpRequest originalRequest, boolean proxy, boolean preserveHost) {
        this.uri = this.escapeUnsafeCharacters(uri);
        this.originalRequest = originalRequest;
        this.proxy = proxy;
        this.preserveHost = preserveHost;
    }

    private String escapeUnsafeCharacters(String url) {
        String result = url;
        for (int i = 0; i < UNSAFE.length; ++i) {
            result = result.replaceAll(Pattern.quote(UNSAFE[i]), ESCAPED[i]);
        }
        return result;
    }

    public HttpClientResponse execute(HttpClient httpClient) throws IOException {
        this.buildHttpMethod();
        URL url = new URL(this.uri);
        HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        if (this.preserveHost) {
            int originalport = -1;
            if (this.originalRequest.getServerPort() != 80 && this.originalRequest.getServerPort() != 443) {
                originalport = this.originalRequest.getServerPort();
            }
            HttpHost virtualHost = new HttpHost(this.originalRequest.getServerName(), originalport, this.originalRequest.getScheme());
            ClientParamBean clientParamBean = new ClientParamBean(this.httpRequest.getParams());
            clientParamBean.setVirtualHost(virtualHost);
        }
        long start = System.currentTimeMillis();
        HttpClientResponse result = new HttpClientResponse(httpHost, (HttpRequest)this.httpRequest, httpClient, this.cookieStore);
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString() + " -> " + result.toString() + " (" + (end - start) + " ms)");
        }
        return result;
    }

    private void copyEntity(org.esigate.api.HttpRequest req, HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws IOException {
        String contentEncoding;
        long contentLengthLong = -1L;
        String contentLength = req.getHeader("Content-Length");
        if (contentLength != null) {
            contentLengthLong = Long.parseLong(contentLength);
        }
        InputStreamEntity inputStreamEntity = new InputStreamEntity(req.getInputStream(), contentLengthLong);
        String contentType = req.getContentType();
        if (contentType != null) {
            inputStreamEntity.setContentType(contentType);
        }
        if ((contentEncoding = req.getHeader("Content-Encoding")) != null) {
            inputStreamEntity.setContentEncoding(contentEncoding);
        }
        httpEntityEnclosingRequest.setEntity((HttpEntity)inputStreamEntity);
    }

    private void buildHttpMethod() throws IOException {
        Integer maxWait;
        String method = this.proxy ? this.originalRequest.getMethod() : "GET";
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "OPTIONS".equalsIgnoreCase(method) || "TRACE".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) {
            this.httpRequest = new BasicHttpRequest(method, this.uri);
        } else if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PROPFIND".equalsIgnoreCase(method) || "PROPPATCH".equalsIgnoreCase(method) || "MKCOL".equalsIgnoreCase(method) || "COPY".equalsIgnoreCase(method) || "MOVE".equalsIgnoreCase(method) || "LOCK".equalsIgnoreCase(method) || "UNLOCK".equalsIgnoreCase(method)) {
            BasicHttpEntityEnclosingRequest genericHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest(method, this.uri);
            this.copyEntity(this.originalRequest, (HttpEntityEnclosingRequest)genericHttpEntityEnclosingRequest);
            this.httpRequest = genericHttpEntityEnclosingRequest;
        } else {
            throw new UnsupportedHttpMethodException(method + " " + this.uri);
        }
        this.httpRequest.getParams().setParameter("http.protocol.handle-redirects", (Object)(!this.proxy ? 1 : 0));
        this.httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        String userAgent = this.originalRequest.getHeader("User-Agent");
        if (userAgent != null) {
            this.httpRequest.getParams().setParameter("http.useragent", (Object)userAgent);
        }
        if ((maxWait = this.originalRequest.getFetchMaxWait()) != null) {
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpRequest.getParams(), (int)maxWait);
        }
        this.copyRequestHeader("Accept");
        this.copyRequestHeader("Accept-Encoding");
        this.copyRequestHeader("Accept-Language");
        this.copyRequestHeader("Accept-Charset");
        this.copyRequestHeader("Cache-Control");
        this.copyRequestHeader("Pragma");
        String xForwardedFor = this.originalRequest.getHeader("X-Forwarded-For");
        if (xForwardedFor == null) {
            xForwardedFor = this.originalRequest.getRemoteAddr();
        }
        if (xForwardedFor != null) {
            this.httpRequest.addHeader("X-Forwarded-For", xForwardedFor);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                this.httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void copyRequestHeader(String name) {
        String value;
        if (this.originalRequest != null && (value = this.originalRequest.getHeader(name)) != null) {
            this.httpRequest.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public String toString() {
        return this.httpRequest.getRequestLine().toString();
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public void setPreserveHost(boolean preserveHost) {
        this.preserveHost = preserveHost;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }
}

