/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.esigate.ConfigurationException;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.ResourceFactory;
import org.esigate.ResponseException;
import org.esigate.cache.Cache;
import org.esigate.cache.CacheOutput;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.CachedResponse;
import org.esigate.file.FileOutput;
import org.esigate.file.FileResource;
import org.esigate.output.MultipleOutput;
import org.esigate.output.Output;
import org.esigate.resource.NullResource;
import org.esigate.resource.Resource;
import org.esigate.resource.ResourceUtils;
import org.esigate.util.Rfc2616;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedHttpResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(CachedHttpResourceFactory.class);
    private final ResourceFactory parent;
    private final DriverConfiguration config;
    private final Cache cache;

    public CachedHttpResourceFactory(ResourceFactory parent, DriverConfiguration config) {
        this.parent = parent;
        this.config = config;
        this.cache = new Cache();
        try {
            CacheStorage cacheStorage = this.config.getCacheStorageClass().newInstance();
            cacheStorage.init(config.getProperties());
            this.cache.setStorage(cacheStorage);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error during initialization CacheStorage", e);
        }
    }

    public Resource getResource(ResourceContext resourceContext) throws HttpErrorPage {
        String httpUrl = ResourceUtils.getHttpUrlWithQueryString(resourceContext);
        ResourceProxyWithContext ret = new ResourceProxyWithContext();
        ret.setResourceContext(resourceContext);
        ret.setCache(this.cache);
        ret.setHttpUrl(httpUrl);
        try {
            this.tryLoadFromCache(ret);
            if (!ret.isReady()) {
                this.tryLoadFromHttp(ret);
            }
            if (!ret.isReady()) {
                this.tryLoadFromExpiredCache(ret);
            }
            if (!ret.isReady()) {
                this.tryLoadFromFileSystem(ret);
            }
            if (!ret.isReady()) {
                this.loadWithError(ret);
            }
            return ret;
        }
        catch (Throwable t) {
            ret.setMemoryOutput(null);
            if (ret.getFileOutput() != null) {
                ret.getFileOutput().delete();
            }
            throw new ResponseException(httpUrl + " could not be retrieved", t);
        }
    }

    private void loadWithError(ResourceProxyWithContext ret) {
        if (ret.getHttpResource() != null) {
            ret.setProxyResource(ret.getHttpResource());
            ret.setReady(true);
        } else if (ret.getCachedResource() != null) {
            ret.setProxyResource(ret.getHttpResource());
            ret.setReady(true);
        } else if (ret.getFileResource() != null) {
            ret.setProxyResource(ret.getFileResource());
            ret.setReady(true);
        } else {
            ret.setProxyResource(new NullResource());
            ret.setReady(true);
        }
    }

    private void tryLoadFromFileSystem(ResourceProxyWithContext ret) throws IOException {
        if (this.config.getLocalBase() != null && Rfc2616.isCacheable(ret.getResourceContext())) {
            ret.setFileResource(ResourceUtils.createFileResource(this.config.getLocalBase(), ret.getResourceContext()));
            if (!ret.getFileResource().isError()) {
                ret.setFileOutput(null);
                ret.setMemoryOutput(new CacheOutput(this.config.getCacheMaxFileSize()));
                ret.setProxyResource(ret.getFileResource());
                ret.setReady(true);
                log.info("Using filesystem for: " + ret.getHttpUrl());
            }
        }
    }

    private void tryLoadFromExpiredCache(ResourceProxyWithContext ret) {
        if (ret.getCachedResource() != null && !ret.getCachedResource().isError()) {
            ret.setProxyResource(ret.getCachedResource());
            ret.setReady(true);
            log.info("Reusing expired cache entry for: " + ret.getHttpUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLoadFromHttp(ResourceProxyWithContext ret) throws Exception, HttpErrorPage {
        if (this.config.getBaseURL() != null) {
            if (this.config.isPutInCache() && Rfc2616.isCacheable(ret.getResourceContext())) {
                ret.setFileOutput(ResourceUtils.createFileOutput(this.config.getLocalBase(), ret.getResourceContext()));
            }
            Map<String, String> validators = this.cache.getValidators(ret.getResourceContext(), ret.getCachedResource());
            ResourceContext resourceContext = ret.getResourceContext();
            Map<String, String> originalValidators = resourceContext.getValidators();
            try {
                resourceContext.setValidators(validators);
                ret.setHttpResource(this.parent.getResource(resourceContext));
            }
            finally {
                resourceContext.setValidators(originalValidators);
            }
            ret.setHttpResource(this.cache.select(ret.getResourceContext(), ret.getCachedResource(), ret.getHttpResource()));
            if (!ret.getHttpResource().isError()) {
                ret.setProxyResource(ret.getHttpResource());
                ret.setReady(true);
            }
        }
    }

    private void tryLoadFromCache(ResourceProxyWithContext ret) {
        if (!Rfc2616.isCacheable(ret.getResourceContext())) {
            return;
        }
        ret.setCachedResource(this.cache.get(ret.getResourceContext()));
        boolean needsValidation = true;
        if (ret.getCachedResource() != null) {
            needsValidation = false;
            if (this.config.getCacheRefreshDelay() > 0) {
                boolean bl = needsValidation = Rfc2616.requiresRefresh(ret.getResourceContext()) || Rfc2616.getAge(ret.getCachedResource()) > (long)this.config.getCacheRefreshDelay() * 1000L;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Needs validation={} cacheRefreshDelay={} cachedResource={}", new Object[]{needsValidation, this.config.getCacheRefreshDelay(), ret.getCachedResource()});
        }
        if (needsValidation) {
            ret.setMemoryOutput(new CacheOutput(this.config.getCacheMaxFileSize()));
            if (log.isInfoEnabled()) {
                if (ret.getCachedResource() == null) {
                    log.info("Not in cache: " + ret.getHttpUrl());
                } else {
                    StringBuilder validators = new StringBuilder();
                    Set<Map.Entry<String, String>> entrySet = this.cache.getValidators(ret.getResourceContext(), ret.getCachedResource()).entrySet();
                    for (Map.Entry<String, String> validator : entrySet) {
                        validators.append(validator.getKey()).append(": ").append(validator.getValue()).append(";");
                    }
                    log.info("Cache entry needs validation: {}; validators: {}", (Object)ret.getHttpUrl(), (Object)validators);
                }
            }
        } else {
            log.info("Reusing cache entry for: " + ret.getHttpUrl());
            ret.setProxyResource(ret.getCachedResource());
            ret.setReady(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceProxyWithContext
    extends Resource {
        private Resource resource;
        private CachedResponse cachedResource = null;
        private Resource httpResource = null;
        private FileResource fileResource = null;
        private CacheOutput memoryOutput = null;
        private FileOutput fileOutput = null;
        private ResourceContext resourceContext;
        private Cache cache = null;
        private String httpUrl = null;
        private boolean ready = false;

        private ResourceProxyWithContext() {
        }

        public String getHttpUrl() {
            return this.httpUrl;
        }

        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        public boolean isReady() {
            return this.ready;
        }

        public void setReady(boolean ready) {
            this.ready = ready;
        }

        public CachedResponse getCachedResource() {
            return this.cachedResource;
        }

        public void setProxyResource(Resource resource) {
            this.resource = resource;
        }

        public void setCachedResource(CachedResponse cachedResource) {
            this.cachedResource = cachedResource;
        }

        public Resource getHttpResource() {
            return this.httpResource;
        }

        public void setHttpResource(Resource httpResource) {
            this.httpResource = httpResource;
        }

        public FileResource getFileResource() {
            return this.fileResource;
        }

        public void setFileResource(FileResource fileResource) {
            this.fileResource = fileResource;
        }

        public void setMemoryOutput(CacheOutput memoryOutput) {
            this.memoryOutput = memoryOutput;
        }

        public FileOutput getFileOutput() {
            return this.fileOutput;
        }

        public void setFileOutput(FileOutput fileOutput) {
            this.fileOutput = fileOutput;
        }

        public ResourceContext getResourceContext() {
            return this.resourceContext;
        }

        public void setResourceContext(ResourceContext resourceContext) {
            this.resourceContext = resourceContext;
        }

        public void setCache(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void render(Output output) throws IOException {
            MultipleOutput multipleOutput = new MultipleOutput();
            multipleOutput.addOutput(output);
            if (null != this.memoryOutput) {
                multipleOutput.addOutput(this.memoryOutput);
            }
            if (null != this.fileOutput) {
                multipleOutput.addOutput(this.fileOutput);
            }
            this.resource.render(multipleOutput);
        }

        @Override
        public void release() {
            if (this.cachedResource != null) {
                this.cachedResource.release();
            }
            if (this.memoryOutput != null && this.cache != null) {
                this.cache.put(this.resourceContext, this.memoryOutput.toResource());
            }
            if (this.httpResource != null) {
                this.httpResource.release();
            }
            if (this.fileResource != null) {
                this.fileResource.release();
            }
        }

        @Override
        public int getStatusCode() {
            return this.resource.getStatusCode();
        }

        @Override
        public String getHeader(String name) {
            return this.resource.getHeader(name);
        }

        @Override
        public Collection<String> getHeaders(String name) {
            return this.resource.getHeaders(name);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this.resource.getHeaderNames();
        }

        @Override
        public boolean isError() {
            return this.resource.isError();
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        @Override
        public String getRequestHeader(String name) {
            return this.resource.getRequestHeader(name);
        }

        @Override
        public boolean hasResponseBody() {
            return this.resource.hasResponseBody();
        }

        @Override
        public Date getLocalDate() {
            return this.resource.getLocalDate();
        }

        public boolean equals(Object obj) {
            return this.resource.equals(obj);
        }

        public String toString() {
            return this.resource.toString();
        }

        @Override
        public String getStatusMessage() {
            return this.resource.getStatusMessage();
        }
    }
}

