/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.esigate.file.FileUtils;
import org.esigate.file.HeadersFile;
import org.esigate.output.Output;
import org.esigate.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResource
extends Resource {
    private File file;
    private final HeadersFile headersFile;

    public FileResource(File dataFile, File headersFile) throws IOException {
        this.file = dataFile;
        this.headersFile = this.file.exists() && headersFile.exists() ? FileUtils.loadHeaders(headersFile) : new HeadersFile(404, "Not found");
    }

    @Override
    public void release() {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Output output) throws IOException {
        output.setStatus(this.headersFile.getStatusCode(), this.headersFile.getStatusMessage());
        for (Map.Entry<String, Set<String>> header : this.headersFile.getHeadersMap().entrySet()) {
            Set<String> values = header.getValue();
            for (String value : values) {
                output.addHeader(header.getKey(), value);
            }
        }
        if (this.file != null) {
            FileInputStream inputStream = new FileInputStream(this.file);
            try {
                output.open();
                OutputStream out = output.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
            finally {
                ((InputStream)inputStream).close();
                output.close();
            }
        }
    }

    @Override
    public int getStatusCode() {
        return this.headersFile.getStatusCode();
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headersFile.getHeadersMap().keySet();
    }

    @Override
    public String getHeader(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return this.headersFile.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.headersFile.getHeaders(name);
    }

    @Override
    public String getStatusMessage() {
        return this.headersFile.getStatusMessage();
    }
}

