/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.CachedResponse;
import org.esigate.cache.CachedResponseSummary;
import org.esigate.resource.Resource;
import org.esigate.util.Rfc2616;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheEntry
implements Serializable {
    private static final long serialVersionUID = 7110248280110189961L;
    private static final Logger LOG = LoggerFactory.getLogger(CacheEntry.class);
    private static final long CLEAN_DELAY = 900000L;
    private static final Pattern ETAG_PATTERN = Pattern.compile(",?\\s*((W/)?\"[^\"]*\")");
    private final String url;
    private transient CacheStorage storage;
    private transient boolean dirty;
    private long lastClean = -1L;
    private final Set<CachedResponseSummary> responseSummaries = new CopyOnWriteArraySet<CachedResponseSummary>();

    public String getUrl() {
        return this.url;
    }

    public CacheEntry(String url, CacheStorage storage) {
        this.url = url;
        this.storage = storage;
        this.dirty = false;
    }

    public CachedResponse get(ResourceContext resourceContext) {
        CachedResponse result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("get(" + resourceContext.getRelUrl() + ")");
        }
        for (CachedResponseSummary summary : this.responseSummaries) {
            CachedResponse cachedResponse;
            if (!Rfc2616.matches(resourceContext, summary) || (cachedResponse = this.getCacheResponseAndClean(summary)) == null) continue;
            result = cachedResponse;
            this.storage.touch(summary.getCacheKey());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("get(" + summary + ")=" + result);
        }
        if (LOG.isDebugEnabled() && result == null) {
            LOG.debug("get(" + resourceContext.getRelUrl() + ") : Not found.");
        }
        return result;
    }

    private CachedResponse getCacheResponseAndClean(CachedResponseSummary summary) {
        CachedResponse cachedResponse = this.storage.get(summary.getCacheKey(), CachedResponse.class);
        if (cachedResponse == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource " + summary.getCacheKey() + "is no longer in cache. Removing");
            }
            this.dirty = this.responseSummaries.remove(summary);
        }
        return cachedResponse;
    }

    private CachedResponse getFirstCacheResponse() {
        CachedResponseSummary summary;
        CachedResponse cachedResponse = null;
        Iterator<CachedResponseSummary> i$ = this.responseSummaries.iterator();
        while (i$.hasNext() && (cachedResponse = this.getCacheResponseAndClean(summary = i$.next())) == null) {
        }
        return cachedResponse;
    }

    public Map<String, String> getValidators(ResourceContext resourceContext, Resource cachedResponse) {
        String ifModifiedSince;
        HashMap<String, String> result = new HashMap<String, String>();
        String ifNoneMatch = this.getIfNoneMatch(resourceContext);
        if (ifNoneMatch != null) {
            result.put("If-None-Match", ifNoneMatch);
        }
        if ((ifModifiedSince = this.getIfModifiedSince(resourceContext, cachedResponse)) != null) {
            result.put("If-Modified-Since", ifModifiedSince);
        }
        return result;
    }

    private String getIfNoneMatch(ResourceContext resourceContext) {
        String ifNoneMatch;
        HashSet<String> etags = new HashSet<String>();
        if (resourceContext.isProxy() && !resourceContext.isNeededForTransformation() && (ifNoneMatch = resourceContext.getOriginalRequest().getHeader("If-None-Match")) != null) {
            Matcher matcher = ETAG_PATTERN.matcher(ifNoneMatch);
            while (!matcher.hitEnd()) {
                if (!matcher.find()) continue;
                etags.add(matcher.group(1));
            }
        }
        for (CachedResponseSummary key : this.responseSummaries) {
            String etag;
            CachedResponse cachedResponse = this.getCacheResponseAndClean(key);
            if (cachedResponse == null || (etag = cachedResponse.getHeader("ETag")) == null || !cachedResponse.hasResponseBody()) continue;
            etags.add(etag);
        }
        if (!etags.isEmpty()) {
            Iterator iterator = etags.iterator();
            StringBuilder etagsString = new StringBuilder((String)iterator.next());
            while (iterator.hasNext()) {
                etagsString.append(", ").append((String)iterator.next());
            }
            return etagsString.toString();
        }
        return null;
    }

    private String getIfModifiedSince(ResourceContext resourceContext, Resource cachedResponse) {
        String requestedIfModifiedSinceString = resourceContext.getOriginalRequest().getHeader("If-Modified-Since");
        Date requestedIfModifiedSinceDate = Rfc2616.getDateHeader(resourceContext, "If-Modified-Since");
        String cacheLastModifiedString = null;
        Date cacheLastModifiedDate = null;
        if (cachedResponse != null && cachedResponse.hasResponseBody()) {
            cacheLastModifiedString = cachedResponse.getHeader("Last-Modified");
            cacheLastModifiedDate = Rfc2616.getDateHeader(cachedResponse, "Last-Modified");
        }
        if (resourceContext.isNeededForTransformation() || requestedIfModifiedSinceDate == null || cacheLastModifiedDate != null && cacheLastModifiedDate.after(requestedIfModifiedSinceDate)) {
            return cacheLastModifiedString;
        }
        return requestedIfModifiedSinceString;
    }

    public Resource select(ResourceContext resourceContext, CachedResponse cachedResponse, Resource newResource) throws HttpErrorPage {
        if (LOG.isDebugEnabled()) {
            LOG.debug("select(" + resourceContext.getRelUrl() + ")");
        }
        Resource result = null;
        if (newResource.getStatusCode() == 304) {
            String etag = Rfc2616.getEtag(newResource);
            if (etag == null) {
                String sentIfModifiedSince = this.getIfModifiedSince(resourceContext, cachedResponse);
                if (sentIfModifiedSince != null) {
                    result = !resourceContext.isNeededForTransformation() && sentIfModifiedSince.equals(resourceContext.getOriginalRequest().getHeader("If-Modified-Since")) ? newResource : cachedResponse;
                } else if (cachedResponse != null) {
                    result = cachedResponse;
                } else if (this.getFirstCacheResponse() != null) {
                    result = this.getFirstCacheResponse();
                }
            } else {
                result = !resourceContext.isNeededForTransformation() && (resourceContext.getOriginalRequest().getHeader("If-None-Match") != null && Rfc2616.etagMatches(resourceContext, newResource) || resourceContext.getOriginalRequest().getHeader("If-Modified-Since") != null) ? newResource : this.findByEtag(etag);
            }
            if (cachedResponse != null) {
                this.updateHeaders(cachedResponse, newResource);
            }
            if (result == null) {
                LOG.warn("Invalid 304 response, neededForTransformation: " + resourceContext.isNeededForTransformation() + " etag: " + etag);
                throw new HttpErrorPage(412, "Invalid 304 response", "Invalid 304 response");
            }
        } else {
            result = newResource;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("select(" + resourceContext.getRelUrl() + ")=" + result);
        }
        return result;
    }

    private CachedResponse findByEtag(String etag) {
        LOG.debug("findByEtag(" + etag + ")");
        for (CachedResponseSummary summary : this.responseSummaries) {
            CachedResponse cachedResponse;
            if (!etag.equals(Rfc2616.getEtag(summary)) || (cachedResponse = this.getCacheResponseAndClean(summary)) == null) continue;
            return cachedResponse;
        }
        return null;
    }

    private void copyHeader(Resource source, CachedResponse dest, String name) {
        Collection<String> values = source.getHeaders(name);
        for (String value : values) {
            dest.addHeader(name, value);
        }
    }

    private void updateHeaders(CachedResponse cachedResponse, Resource newResource) {
        this.copyHeader(newResource, cachedResponse, "Date");
        this.copyHeader(newResource, cachedResponse, "Content-Type");
        this.copyHeader(newResource, cachedResponse, "Content-Length");
        this.copyHeader(newResource, cachedResponse, "Last-Modified");
        this.copyHeader(newResource, cachedResponse, "ETag");
        this.copyHeader(newResource, cachedResponse, "Expires");
        this.copyHeader(newResource, cachedResponse, "Cache-Control");
        this.copyHeader(newResource, cachedResponse, "Content-Encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ResourceContext resourceContext, CachedResponse resource) {
        if (resource != null && resource.getStatusCode() != 304) {
            resource.setRequestHeadersFromRequest(resourceContext.getOriginalRequest());
            String key = this.getCacheKey(resourceContext, resource);
            CachedResponseSummary summary = resource.getSummary(key);
            this.responseSummaries.remove(summary);
            this.responseSummaries.add(summary);
            this.storage.put(key, resource);
            this.dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("put(" + key + ")");
            }
        }
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (System.currentTimeMillis() - this.lastClean > 900000L) {
                for (CachedResponseSummary summary : this.responseSummaries) {
                    this.getCacheResponseAndClean(summary);
                }
                this.lastClean = System.currentTimeMillis();
            }
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.url).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheEntry)) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        return new EqualsBuilder().append((Object)this.url, (Object)other.url).isEquals();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    private String getCacheKey(ResourceContext resourceContext, Resource resource) {
        Map<String, String> vary;
        StringBuilder cacheKey = new StringBuilder().append(CachedResponse.class.getName()).append(" ").append(this.url).append(" ");
        String etag = Rfc2616.getEtag(resource);
        if (etag != null) {
            cacheKey.append(" etag=").append(etag);
        }
        if ((vary = Rfc2616.getVary(resourceContext, resource)) != null) {
            cacheKey.append(" vary={");
            for (Map.Entry<String, String> header : vary.entrySet()) {
                cacheKey.append(header.getKey()).append("=").append(header.getValue()).append(";");
            }
            cacheKey.append("}");
        }
        return cacheKey.toString();
    }

    public void setStorage(CacheStorage storage) {
        this.storage = storage;
    }
}

