/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cas;

import java.security.Principal;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.extension.Extension;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;
import org.esigate.util.Parameter;
import org.esigate.util.ParameterString;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationHandler
implements IEventListener,
Extension {
    public static final Parameter<String> CAS_LOGIN_URL = new ParameterString("casLoginUrl", "/login");
    private static final Logger LOG = LoggerFactory.getLogger(CasAuthenticationHandler.class);
    private Driver driver;
    private String loginUrl;

    private void addCasAuthentication(OutgoingRequest outgoingRequest, IncomingRequest incomingRequest) {
        String location;
        String resultLocation = location = outgoingRequest.getRequestLine().getUri();
        AttributePrincipal principal = this.getCasAuthentication(incomingRequest);
        if (principal != null) {
            LOG.debug("User logged in CAS as: " + principal.getName());
            String casProxyTicket = principal.getProxyTicketFor(resultLocation);
            LOG.debug("Proxy ticket retrieved: " + principal.getName() + " for service: " + location + " : " + casProxyTicket);
            if (casProxyTicket != null) {
                resultLocation = resultLocation.indexOf("?") > 0 ? resultLocation + "&ticket=" + casProxyTicket : resultLocation + "?ticket=" + casProxyTicket;
            }
        }
        outgoingRequest.setUri(resultLocation);
    }

    public boolean event(EventDefinition id, Event event) {
        if (EventManager.EVENT_FRAGMENT_POST.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            IncomingRequest incomingRequest = e.getOriginalRequest();
            CloseableHttpResponse httpResponse = e.getHttpResponse();
            if (this.isRedirectToCasServer((HttpResponse)httpResponse)) {
                if (this.getCasAuthentication(incomingRequest) != null) {
                    LOG.debug("CAS authentication required for {}", (Object)e);
                    EntityUtils.consumeQuietly((HttpEntity)e.getHttpResponse().getEntity());
                    e.setHttpResponse(null);
                    this.addCasAuthentication(e.getHttpRequest(), e.getOriginalRequest());
                    try {
                        LOG.debug("Sending new request {}", (Object)e);
                        e.setHttpResponse(this.driver.getRequestExecutor().execute(e.getHttpRequest()));
                    }
                    catch (HttpErrorPage e1) {
                        e.setHttpResponse(e1.getHttpResponse());
                    }
                } else {
                    LOG.debug("CAS authentication required but we are not authenticated for {}", (Object)e);
                    e.setHttpResponse(HttpErrorPage.generateHttpResponse((int)401, (String)"CAS authentication required"));
                }
            }
        }
        return true;
    }

    private AttributePrincipal getCasAuthentication(IncomingRequest incomingRequest) {
        Principal principal = incomingRequest.getUserPrincipal();
        if (principal != null && principal instanceof AttributePrincipal) {
            return (AttributePrincipal)principal;
        }
        return null;
    }

    public final void init(Driver d, Properties properties) {
        this.driver = d;
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, (IEventListener)this);
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, (IEventListener)this);
        this.loginUrl = (String)CAS_LOGIN_URL.getValue(properties);
    }

    private boolean isRedirectToCasServer(HttpResponse httpResponse) {
        String locationHeaderValue;
        Header locationHeader = httpResponse.getFirstHeader("Location");
        return locationHeader != null && (locationHeaderValue = locationHeader.getValue()) != null && locationHeaderValue.contains(this.loginUrl);
    }
}

