/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cas;

import java.security.Principal;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.Driver;
import org.esigate.authentication.GenericAuthentificationHandler;
import org.esigate.cas.CASRedirectStrategy;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;
import org.esigate.http.RedirectStrategy;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationHandler
extends GenericAuthentificationHandler {
    private static final String DEFAULT_LOGIN_URL = "/login";
    private static final Logger LOG = LoggerFactory.getLogger(GenericAuthentificationHandler.class);
    protected static final String LOGIN_URL_PROPERTY = "casLoginUrl";
    protected static final String SECOND_REQUEST = "SECOND_REQUEST";
    private static final String SPRING_SECURITY_PROPERTY = "isSpringSecurity";
    private static final String SPRING_SECURITY_URL_PATTERN_PROPERTY = "springSecurityUrl";
    private String loginUrl;
    private boolean springSecurity;
    private String springSecurityUrl;

    private void addCasAuthentication(OutgoingRequest outgoingRequest, IncomingRequest request) {
        String location;
        String resultLocation = location = outgoingRequest.getRequestLine().getUri();
        Principal principal = request.getUserPrincipal();
        if (principal != null && principal instanceof AttributePrincipal) {
            AttributePrincipal casPrincipal = (AttributePrincipal)principal;
            LOG.debug("User logged in CAS as: " + casPrincipal.getName());
            String springRedirectParam = "";
            if (this.springSecurity) {
                String params = null;
                if (resultLocation.indexOf("?") != -1) {
                    params = resultLocation.substring(resultLocation.indexOf("?"));
                    LOG.debug("params: " + params.substring(1));
                }
                if (this.springSecurityUrl != null && !"".equals(this.springSecurityUrl)) {
                    resultLocation = outgoingRequest.getBaseUrl() + this.springSecurityUrl;
                    if (params != null) {
                        resultLocation = resultLocation + params;
                    }
                    springRedirectParam = "&spring-security-redirect=" + location;
                    LOG.debug("getIsSpringSecurity=true => updated location: " + resultLocation);
                }
            }
            String casProxyTicket = casPrincipal.getProxyTicketFor(resultLocation);
            LOG.debug("Proxy ticket retrieved: " + casPrincipal.getName() + " for service: " + location + " : " + casProxyTicket);
            if (casProxyTicket != null) {
                resultLocation = resultLocation.indexOf("?") > 0 ? resultLocation + "&ticket=" + casProxyTicket + springRedirectParam : resultLocation + "?ticket=" + casProxyTicket + springRedirectParam;
            }
        }
        outgoingRequest.setUri(resultLocation);
    }

    public boolean beforeProxy(HttpRequest request) {
        return true;
    }

    protected String driverSpecificName(Driver driver, String name) {
        return driver.getConfiguration().getInstanceName() + "-" + name;
    }

    public void init(Properties properties) {
        this.loginUrl = properties.getProperty(LOGIN_URL_PROPERTY);
        if (this.loginUrl == null) {
            this.loginUrl = DEFAULT_LOGIN_URL;
        }
        CASRedirectStrategy strategy = new CASRedirectStrategy();
        strategy.setLoginURL(this.loginUrl);
        this.getDriver().setRedirectStrategy((RedirectStrategy)strategy);
        String springSecurityString = properties.getProperty(SPRING_SECURITY_PROPERTY);
        this.springSecurity = springSecurityString != null ? Boolean.parseBoolean(springSecurityString) : false;
        this.springSecurityUrl = properties.getProperty(SPRING_SECURITY_URL_PATTERN_PROPERTY);
    }

    public boolean needsNewRequest(HttpResponse httpResponse, OutgoingRequest outgoingRequest, IncomingRequest incomingRequest) {
        String secondRequestAttribute = this.driverSpecificName(outgoingRequest.getOriginalRequest().getDriver(), SECOND_REQUEST);
        Boolean secondRequest = (Boolean)incomingRequest.getAttribute(secondRequestAttribute);
        if (secondRequest == null) {
            secondRequest = Boolean.FALSE;
        }
        if (secondRequest.booleanValue()) {
            Principal principal;
            Header locationHeader = httpResponse.getFirstHeader("Location");
            String currentLocation = null;
            if (locationHeader != null) {
                currentLocation = locationHeader.getValue();
            }
            if (currentLocation != null && currentLocation.contains(this.loginUrl) && (principal = incomingRequest.getUserPrincipal()) != null && principal instanceof AttributePrincipal) {
                return true;
            }
        }
        return false;
    }

    public void preRequest(OutgoingRequest outgoingRequest, IncomingRequest incomingRequest) {
        String secondRequestAttribute = this.driverSpecificName(outgoingRequest.getOriginalRequest().getDriver(), SECOND_REQUEST);
        Boolean secondRequest = (Boolean)incomingRequest.getAttribute(secondRequestAttribute);
        if (secondRequest == null) {
            secondRequest = Boolean.FALSE;
        }
        if (secondRequest.booleanValue()) {
            this.addCasAuthentication(outgoingRequest, incomingRequest);
        }
        incomingRequest.setAttribute(secondRequestAttribute, (Object)true);
    }
}

