/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cas;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.esigate.http.RedirectStrategy;

public class CASRedirectStrategy
extends RedirectStrategy {
    private String loginURL;

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)response, (String)"HTTP response");
        int statusCode = response.getStatusLine().getStatusCode();
        Header locationHeader = response.getFirstHeader("location");
        switch (statusCode) {
            case 301: 
            case 302: 
            case 307: {
                return super.isRedirected(request, response, context) && !locationHeader.getValue().contains(this.loginURL);
            }
        }
        return super.isRedirected(request, response, context);
    }

    public void setLoginURL(String loginURL) {
        this.loginURL = loginURL;
    }
}

