/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class CacheInvalidatorRegistry {
    private final Map<String, CacheInvalidator> cacheInvalidators = new ConcurrentHashMap<String, CacheInvalidator>();
    private final Map<String, Set<String>> cacheAliases = new ConcurrentHashMap<String, Set<String>>();

    public void registerCacheInvalidator(String name, CacheInvalidator cacheInvalidator) {
        if (this.cacheInvalidators.containsKey(name)) {
            throw new IllegalArgumentException("Cache invalidator registry already has an entry with name: [" + name + "]");
        }
        this.cacheInvalidators.put(name, cacheInvalidator);
    }

    public void registerAlias(String alias, Set<String> names) {
        Objects.requireNonNull(alias, "cache alias cannot be null");
        if (names.isEmpty()) {
            throw new IllegalArgumentException("cache names cannot be empty for aliasing");
        }
        if (this.cacheAliases.containsKey(alias)) {
            throw new IllegalArgumentException("cache alias already exists: [" + alias + "]");
        }
        this.cacheAliases.put(alias, names);
    }

    public void validate() {
        for (String alias : this.cacheAliases.keySet()) {
            if (this.cacheInvalidators.containsKey(alias)) {
                throw new IllegalStateException("cache alias cannot clash with cache name: [" + alias + "]");
            }
            Set<String> names = this.cacheAliases.get(alias);
            if (this.cacheInvalidators.keySet().containsAll(names)) continue;
            throw new IllegalStateException("cache names not found: [" + Strings.collectionToCommaDelimitedString((Iterable)Sets.difference(names, this.cacheInvalidators.keySet())) + "]");
        }
    }

    public void onSecurityIndexStateChange(ProjectId projectId, SecurityIndexManager.IndexState previousState, SecurityIndexManager.IndexState currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || !Objects.equals(previousState.indexUUID, currentState.indexUUID) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.cacheInvalidators.values().stream().filter(CacheInvalidator::shouldClearOnSecurityIndexStateChange).forEach(CacheInvalidator::invalidateAll);
        }
    }

    public void invalidateByKey(String cacheName, Collection<String> keys) {
        if (this.cacheAliases.containsKey(cacheName)) {
            this.cacheAliases.get(cacheName).forEach(name -> this.doInvalidateByKey((String)name, keys));
        } else {
            this.doInvalidateByKey(cacheName, keys);
        }
    }

    public void invalidateCache(String cacheName) {
        if (this.cacheAliases.containsKey(cacheName)) {
            this.cacheAliases.get(cacheName).forEach(this::doInvalidateCache);
        } else {
            this.doInvalidateCache(cacheName);
        }
    }

    private void doInvalidateByKey(String cacheName, Collection<String> keys) {
        CacheInvalidator cacheInvalidator = this.cacheInvalidators.get(cacheName);
        if (cacheInvalidator == null) {
            throw new IllegalArgumentException("No cache named [" + cacheName + "] is found");
        }
        cacheInvalidator.invalidate(keys);
    }

    private void doInvalidateCache(String cacheName) {
        CacheInvalidator cacheInvalidator = this.cacheInvalidators.get(cacheName);
        if (cacheInvalidator == null) {
            throw new IllegalArgumentException("No cache named [" + cacheName + "] is found");
        }
        cacheInvalidator.invalidateAll();
    }

    public static interface CacheInvalidator {
        public void invalidate(Collection<String> var1);

        public void invalidateAll();

        default public boolean shouldClearOnSecurityIndexStateChange() {
            return true;
        }
    }
}

