/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.elasticsearch.xpack.core.security.authc.saml.SingleSpSamlRealmSettings;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SigningConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.security.x509.X509Credential;

public class SingleSamlSpConfiguration
implements SpConfiguration {
    private final String entityId;
    private final String ascUrl;
    private final String logoutUrl;
    private final SigningConfiguration signingConfiguration;
    private final List<String> reqAuthnCtxClassRef;
    private final List<X509Credential> encryptionCredentials;

    SingleSamlSpConfiguration(String entityId, String ascUrl, String logoutUrl, SigningConfiguration signingConfiguration, List<X509Credential> encryptionCredentials, List<String> reqAuthnCtxClassRef) {
        this.entityId = entityId;
        this.ascUrl = ascUrl;
        this.logoutUrl = logoutUrl;
        this.signingConfiguration = signingConfiguration;
        this.reqAuthnCtxClassRef = reqAuthnCtxClassRef;
        this.encryptionCredentials = encryptionCredentials;
    }

    public static SingleSamlSpConfiguration create(RealmConfig realmConfig) throws GeneralSecurityException, IOException {
        List<X509Credential> encryptionCredential = SamlRealm.buildEncryptionCredential(realmConfig);
        return new SingleSamlSpConfiguration(SamlRealm.require(realmConfig, (Setting.AffixSetting<String>)SingleSpSamlRealmSettings.SP_ENTITY_ID), SamlRealm.require(realmConfig, (Setting.AffixSetting<String>)SingleSpSamlRealmSettings.SP_ACS), (String)realmConfig.getSetting(SingleSpSamlRealmSettings.SP_LOGOUT), SamlRealm.buildSigningConfiguration(realmConfig), encryptionCredential != null ? encryptionCredential : Collections.emptyList(), (List)realmConfig.getSetting(SamlRealmSettings.REQUESTED_AUTHN_CONTEXT_CLASS_REF));
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getAscUrl() {
        return this.ascUrl;
    }

    @Override
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @Override
    public List<X509Credential> getEncryptionCredentials() {
        return this.encryptionCredentials;
    }

    @Override
    public SigningConfiguration getSigningConfiguration() {
        return this.signingConfiguration;
    }

    @Override
    public List<String> getReqAuthnCtxClassRef() {
        return this.reqAuthnCtxClassRef;
    }
}

