/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class SecuritySystemIndices {
    public static final int INTERNAL_MAIN_INDEX_FORMAT = 6;
    private static final int INTERNAL_TOKENS_INDEX_FORMAT = 7;
    private static final int INTERNAL_TOKENS_INDEX_MAPPINGS_FORMAT = 1;
    private static final int INTERNAL_PROFILE_INDEX_FORMAT = 8;
    private static final int INTERNAL_PROFILE_INDEX_MAPPINGS_FORMAT = 2;
    public static final String SECURITY_MAIN_ALIAS = ".security";
    private static final String MAIN_INDEX_CONCRETE_NAME = ".security-7";
    public static final String SECURITY_TOKENS_ALIAS = ".security-tokens";
    private static final String TOKENS_INDEX_CONCRETE_NAME = ".security-tokens-7";
    public static final String INTERNAL_SECURITY_PROFILE_INDEX_8 = ".security-profile-8";
    public static final String SECURITY_PROFILE_ALIAS = ".security-profile";
    public static final Version VERSION_SECURITY_PROFILE_ORIGIN = Version.V_8_3_0;
    public static final NodeFeature SECURITY_PROFILE_ORIGIN_FEATURE = new NodeFeature("security.security_profile_origin");
    public static final NodeFeature SECURITY_MIGRATION_FRAMEWORK = new NodeFeature("security.migration_framework");
    public static final NodeFeature SECURITY_ROLES_METADATA_FLATTENED = new NodeFeature("security.roles_metadata_flattened");
    public static final NodeFeature SECURITY_ROLE_MAPPING_CLEANUP = new NodeFeature("security.role_mapping_cleanup");
    public static final String BWC_MAPPINGS_VERSION = "8.14.0";
    private static final Logger logger = LogManager.getLogger(SecuritySystemIndices.class);
    private final SystemIndexDescriptor mainDescriptor = this.getSecurityMainIndexDescriptor();
    private final SystemIndexDescriptor tokenDescriptor = SecuritySystemIndices.getSecurityTokenIndexDescriptor();
    private final SystemIndexDescriptor profileDescriptor;
    private final AtomicBoolean initialized;
    private SecurityIndexManager mainIndexManager;
    private SecurityIndexManager tokenIndexManager;
    private SecurityIndexManager profileIndexManager;

    public SecuritySystemIndices(Settings settings) {
        this.profileDescriptor = this.getSecurityProfileIndexDescriptor(settings);
        this.initialized = new AtomicBoolean(false);
        this.mainIndexManager = null;
        this.tokenIndexManager = null;
        this.profileIndexManager = null;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        return List.of(this.mainDescriptor, this.tokenDescriptor, this.profileDescriptor);
    }

    public void init(Client client, FeatureService featureService, ClusterService clusterService) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Already initialized");
        }
        this.mainIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, featureService, this.mainDescriptor);
        this.tokenIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, featureService, this.tokenDescriptor);
        this.profileIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, featureService, this.profileDescriptor);
    }

    public SecurityIndexManager getMainIndexManager() {
        this.checkInitialized();
        return this.mainIndexManager;
    }

    public SecurityIndexManager getTokenIndexManager() {
        this.checkInitialized();
        return this.tokenIndexManager;
    }

    public SecurityIndexManager getProfileIndexManager() {
        return this.profileIndexManager;
    }

    private void checkInitialized() {
        if (!this.initialized.get()) {
            String message = "Attempt access " + this.getClass().getSimpleName() + " before it is initialized";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    private SystemIndexDescriptor getSecurityMainIndexDescriptor() {
        Function<SecurityMainIndexMappingVersion, SystemIndexDescriptor.Builder> securityIndexDescriptorBuilder = mappingVersion -> SystemIndexDescriptor.builder().setIndexPattern(".security-[0-9]+*").setPrimaryIndex(MAIN_INDEX_CONCRETE_NAME).setDescription("Contains Security configuration").setMappings(this.getMainIndexMappings((SecurityMainIndexMappingVersion)((Object)mappingVersion))).setSettings(SecuritySystemIndices.getMainIndexSettings()).setAliasName(SECURITY_MAIN_ALIAS).setIndexFormat(6).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS);
        return securityIndexDescriptorBuilder.apply(SecurityMainIndexMappingVersion.latest()).setPriorSystemIndexDescriptors(List.of(securityIndexDescriptorBuilder.apply(SecurityMainIndexMappingVersion.INITIAL).build())).build();
    }

    private static Settings getMainIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.routing.allocation.include._tier_preference", "data_hot,data_content").put("index.priority", 1000).put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 6).put("analysis.filter.email.type", "pattern_capture").put("analysis.filter.email.preserve_original", true).putList("analysis.filter.email.patterns", List.of("([^@]+)", "(\\p{L}+)", "(\\d+)", "@(.+)")).put("analysis.analyzer.email.tokenizer", "uax_url_email").putList("analysis.analyzer.email.filter", List.of("email", "lowercase", "unique")).build();
    }

    private XContentBuilder getMainIndexMappings(SecurityMainIndexMappingVersion mappingVersion) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", BWC_MAPPINGS_VERSION);
            builder.field("managed_index_mappings_version", mappingVersion.id);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("username");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("roles");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("role_templates");
            builder.startObject("properties");
            builder.startObject("template");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("format");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("password");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("metadata_flattened");
            builder.field("type", "flattened");
            builder.endObject();
            builder.startObject("enabled");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("cluster");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("indices");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("field_security");
            builder.startObject("properties");
            builder.startObject("grant");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("except");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("names");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("query");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("allow_restricted_indices");
            builder.field("type", "boolean");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("remote_indices");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("field_security");
            builder.startObject("properties");
            builder.startObject("grant");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("except");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("names");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("query");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("allow_restricted_indices");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("clusters");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            if (mappingVersion.onOrAfter(SecurityMainIndexMappingVersion.ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS)) {
                builder.startObject("remote_cluster");
                builder.field("type", "object");
                builder.startObject("properties");
                builder.startObject("clusters");
                builder.field("type", "keyword");
                builder.endObject();
                builder.startObject("privileges");
                builder.field("type", "keyword");
                builder.endObject();
                builder.endObject();
                builder.endObject();
            }
            builder.startObject("applications");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("resources");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("global");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("manage");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("applications");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("profile");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("write");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("applications");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            if (mappingVersion.onOrAfter(SecurityMainIndexMappingVersion.ADD_MANAGE_ROLES_PRIVILEGE)) {
                builder.startObject("role");
                builder.field("type", "object");
                builder.startObject("properties");
                builder.startObject("manage");
                builder.field("type", "object");
                builder.startObject("properties");
                builder.startObject("indices");
                builder.startObject("properties");
                builder.startObject("names");
                builder.field("type", "keyword");
                builder.endObject();
                builder.startObject("privileges");
                builder.field("type", "keyword");
                builder.endObject();
                builder.endObject();
                builder.endObject();
                builder.endObject();
                builder.endObject();
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            if (mappingVersion.onOrAfter(SecurityMainIndexMappingVersion.ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS)) {
                builder.startObject("description");
                builder.field("type", "text");
                builder.endObject();
            }
            builder.startObject("run_as");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("actions");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("invalidation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("api_key_hash");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("api_key_invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("limited_by_role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("creator");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("principal");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm_type");
            builder.field("type", "keyword");
            builder.endObject();
            SecuritySystemIndices.defineRealmDomain(builder, "realm_domain");
            builder.endObject();
            builder.endObject();
            builder.startObject("rules");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            logger.fatal("Failed to build .security-7 index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build .security-7 index mappings", e);
        }
    }

    private static SystemIndexDescriptor getSecurityTokenIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-tokens-[0-9]+*").setPrimaryIndex(TOKENS_INDEX_CONCRETE_NAME).setDescription("Contains auth token data").setMappings(SecuritySystemIndices.getTokenIndexMappings()).setSettings(SecuritySystemIndices.getTokenIndexSettings()).setAliasName(SECURITY_TOKENS_ALIAS).setIndexFormat(7).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private static Settings getTokenIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.routing.allocation.include._tier_preference", "data_hot,data_content").put("index.priority", 1000).put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 7).build();
    }

    private static XContentBuilder getTokenIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", BWC_MAPPINGS_VERSION);
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            SecuritySystemIndices.defineRealmDomain(builder, "realm_domain");
            builder.startObject("authentication").field("type", "binary").endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            SecuritySystemIndices.defineRealmDomain(builder, "realm_domain");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .security-tokens-7 index mappings", e);
        }
    }

    private SystemIndexDescriptor getSecurityProfileIndexDescriptor(Settings settings) {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-profile-[0-9]+*").setPrimaryIndex(INTERNAL_SECURITY_PROFILE_INDEX_8).setDescription("Contains user profile documents").setMappings(this.getProfileIndexMappings(2)).setSettings(SecuritySystemIndices.getProfileIndexSettings(settings)).setAliasName(SECURITY_PROFILE_ALIAS).setIndexFormat(8).setVersionMetaKey("security-version").setOrigin("security_profile").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).setMinimumNodeVersion(VERSION_SECURITY_PROFILE_ORIGIN).setPriorSystemIndexDescriptors(List.of(SystemIndexDescriptor.builder().setIndexPattern(".security-profile-[0-9]+*").setPrimaryIndex(INTERNAL_SECURITY_PROFILE_INDEX_8).setDescription("Contains user profile documents").setMappings(this.getProfileIndexMappings(1)).setSettings(SecuritySystemIndices.getProfileIndexSettings(settings)).setAliasName(SECURITY_PROFILE_ALIAS).setIndexFormat(8).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build())).build();
    }

    private static Settings getProfileIndexSettings(Settings settings) {
        Settings.Builder settingsBuilder = Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.routing.allocation.include._tier_preference", "data_hot,data_content").put("index.priority", 1000).put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 8).put("analysis.filter.email.type", "pattern_capture").put("analysis.filter.email.preserve_original", true).putList("analysis.filter.email.patterns", List.of("([^@]+)", "(\\p{L}+)", "(\\d+)", "@(.+)")).put("analysis.analyzer.email.tokenizer", "uax_url_email").putList("analysis.analyzer.email.filter", List.of("email", "lowercase", "unique"));
        if (DiscoveryNode.isStateless((Settings)settings)) {
            settingsBuilder.put(IndexSettings.INDEX_FAST_REFRESH_SETTING.getKey(), true);
        }
        return settingsBuilder.build();
    }

    private XContentBuilder getProfileIndexMappings(int mappingsVersion) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", BWC_MAPPINGS_VERSION);
            builder.field("managed_index_mappings_version", mappingsVersion);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("user_profile");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("uid");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("enabled");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("username");
            builder.field("type", "search_as_you_type");
            builder.startObject("fields");
            builder.startObject("keyword");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("roles");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            SecuritySystemIndices.defineRealmDomain(builder, "domain");
            builder.startObject("node_name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "search_as_you_type");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("last_synchronized");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("labels");
            builder.field("type", "flattened");
            builder.endObject();
            builder.startObject("application_data");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            logger.fatal("Failed to build profile index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build profile index mappings", e);
        }
    }

    private static void defineRealmDomain(XContentBuilder builder, String fieldName) throws IOException {
        builder.startObject(fieldName);
        builder.field("type", "object");
        builder.startObject("properties");
        builder.startObject("name");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("realms");
        builder.field("type", "nested");
        builder.startObject("properties");
        builder.startObject("name");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("type");
        builder.field("type", "keyword");
        builder.endObject();
        builder.endObject();
        builder.endObject();
        builder.endObject();
        builder.endObject();
    }

    public static final class SecurityMainIndexMappingVersion
    extends Enum<SecurityMainIndexMappingVersion>
    implements VersionId<SecurityMainIndexMappingVersion> {
        public static final /* enum */ SecurityMainIndexMappingVersion INITIAL = new SecurityMainIndexMappingVersion(1);
        public static final /* enum */ SecurityMainIndexMappingVersion ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS = new SecurityMainIndexMappingVersion(2);
        public static final /* enum */ SecurityMainIndexMappingVersion ADD_MANAGE_ROLES_PRIVILEGE = new SecurityMainIndexMappingVersion(3);
        private static final SecurityMainIndexMappingVersion LATEST;
        private final int id;
        private static final /* synthetic */ SecurityMainIndexMappingVersion[] $VALUES;

        public static SecurityMainIndexMappingVersion[] values() {
            return (SecurityMainIndexMappingVersion[])$VALUES.clone();
        }

        public static SecurityMainIndexMappingVersion valueOf(String name) {
            return Enum.valueOf(SecurityMainIndexMappingVersion.class, name);
        }

        private SecurityMainIndexMappingVersion(int id) {
            assert (id > 0);
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static SecurityMainIndexMappingVersion latest() {
            return LATEST;
        }

        private static /* synthetic */ SecurityMainIndexMappingVersion[] $values() {
            return new SecurityMainIndexMappingVersion[]{INITIAL, ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS, ADD_MANAGE_ROLES_PRIVILEGE};
        }

        static {
            $VALUES = SecurityMainIndexMappingVersion.$values();
            LATEST = Arrays.stream(SecurityMainIndexMappingVersion.values()).max(Comparator.comparingInt(v -> v.id)).orElseThrow();
        }
    }
}

