/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestUpdateCrossClusterApiKeyAction
extends ApiKeyBaseRestHandler {
    static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("update_cross_cluster_api_key_request_payload", a -> new Payload((CrossClusterApiKeyRoleDescriptorBuilder)a[0], (Map)a[1], TimeValue.parseTimeValue((String)((String)a[2]), null, (String)"expiration")));

    public RestUpdateCrossClusterApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_security/cross_cluster/api_key/{id}"));
    }

    public String getName() {
        return "xpack_security_update_cross_cluster_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String apiKeyId = request.param("id");
        Payload payload = (Payload)PARSER.parse(request.contentParser(), null);
        return channel -> client.execute((ActionType)UpdateCrossClusterApiKeyAction.INSTANCE, (ActionRequest)new UpdateCrossClusterApiKeyRequest(apiKeyId, payload.builder, payload.metadata, payload.expiration), (ActionListener)new RestToXContentListener(channel));
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            return null;
        }
        return LicenseUtils.newComplianceException((String)Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.getName());
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)CrossClusterApiKeyRoleDescriptorBuilder.PARSER, new ParseField("access", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
    }

    record Payload(CrossClusterApiKeyRoleDescriptorBuilder builder, Map<String, Object> metadata, TimeValue expiration) {
    }
}

