/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportChangePasswordAction
extends HandledTransportAction<ChangePasswordRequest, ActionResponse.Empty> {
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("cluster:admin/xpack/security/user/change_password");
    private final Settings settings;
    private final NativeUsersStore nativeUsersStore;
    private final Realms realms;

    @Inject
    public TransportChangePasswordAction(Settings settings, TransportService transportService, ActionFilters actionFilters, NativeUsersStore nativeUsersStore, Realms realms) {
        super(TYPE.name(), transportService, actionFilters, ChangePasswordRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settings = settings;
        this.nativeUsersStore = nativeUsersStore;
        this.realms = realms;
    }

    protected void doExecute(Task task, final ChangePasswordRequest request, final ActionListener<ActionResponse.Empty> listener) {
        Hasher configPwdHashAlgo;
        final String username = request.username();
        if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified via the API"));
            return;
        }
        Hasher requestPwdHashAlgo = Hasher.resolveFromHash((char[])request.passwordHash());
        if (!requestPwdHashAlgo.equals((Object)(configPwdHashAlgo = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(this.settings))))) && !Hasher.getAvailableAlgoStoredHash().contains(requestPwdHashAlgo.name().toLowerCase(Locale.ROOT))) {
            listener.onFailure((Exception)new IllegalArgumentException("The provided password hash is not a hash or it could not be resolved to a supported hash algorithm. The supported password hash algorithms are " + Hasher.getAvailableAlgoStoredHash().toString()));
            return;
        }
        if (ClientReservedRealm.isReservedUsername((String)username) && !((Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(this.settings)).booleanValue()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("user [" + username + "] belongs to the reserved realm which is disabled." + ("elastic".equalsIgnoreCase(username) ? " In a cloud deployment, the password can be changed through the cloud console." : ""));
            listener.onFailure((Exception)validationException);
            return;
        }
        this.nativeUsersStore.getUser(username, new ActionListener<User>(){

            public void onResponse(User user) {
                if (!ClientReservedRealm.isReserved((String)username, (Settings)TransportChangePasswordAction.this.settings) && user == null) {
                    List<Realm> nonNativeRealms = TransportChangePasswordAction.this.realms.getActiveRealms().stream().filter(t -> !Set.of("native", "reserved").contains(t.type())).toList();
                    if (nonNativeRealms.isEmpty()) {
                        listener.onFailure((Exception)TransportChangePasswordAction.createUserNotFoundException());
                        return;
                    }
                    GroupedActionListener gal = new GroupedActionListener(nonNativeRealms.size(), ActionListener.wrap(users -> {
                        Optional<User> nonNativeUser = users.stream().filter(Objects::nonNull).findAny();
                        if (nonNativeUser.isPresent()) {
                            listener.onFailure((Exception)new ValidationException().addValidationError("user [" + username + "] does not belong to the native realm and cannot be managed via this API."));
                        } else {
                            listener.onFailure((Exception)TransportChangePasswordAction.createUserNotFoundException());
                        }
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    for (Realm realm : nonNativeRealms) {
                        EsExecutors.DIRECT_EXECUTOR_SERVICE.execute((Runnable)ActionRunnable.wrap((ActionListener)gal, userActionListener -> realm.lookupUser(username, userActionListener)));
                    }
                } else {
                    TransportChangePasswordAction.this.nativeUsersStore.changePassword(request, (ActionListener<Void>)listener.safeMap(v -> ActionResponse.Empty.INSTANCE));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static ValidationException createUserNotFoundException() {
        ValidationException validationException = new ValidationException();
        validationException.addValidationError("user must exist in order to change password");
        return validationException;
    }
}

