/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.enrollment.tool;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.security.enrollment.ExternalEnrollmentTokenGenerator;
import org.elasticsearch.xpack.security.tool.BaseRunAsSuperuserCommand;

class CreateEnrollmentTokenTool
extends BaseRunAsSuperuserCommand {
    private final OptionSpec<String> scope;
    private final Function<Environment, CommandLineHttpClient> clientFunction;
    private final CheckedFunction<Environment, ExternalEnrollmentTokenGenerator, Exception> createEnrollmentTokenFunction;
    static final List<String> ALLOWED_SCOPES = List.of("node", "kibana");

    CreateEnrollmentTokenTool() {
        this((Environment environment) -> new CommandLineHttpClient(environment), (CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> KeyStoreWrapper.load((Path)environment.configFile())), (CheckedFunction<Environment, ExternalEnrollmentTokenGenerator, Exception>)((CheckedFunction)environment -> new ExternalEnrollmentTokenGenerator((Environment)environment)));
    }

    CreateEnrollmentTokenTool(Function<Environment, CommandLineHttpClient> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction, CheckedFunction<Environment, ExternalEnrollmentTokenGenerator, Exception> createEnrollmentTokenFunction) {
        super(clientFunction, keyStoreFunction, "Creates enrollment tokens for elasticsearch nodes and kibana instances");
        this.createEnrollmentTokenFunction = createEnrollmentTokenFunction;
        this.clientFunction = clientFunction;
        this.scope = this.parser.acceptsAll(List.of("scope", "s"), "The scope of this enrollment token, can be either \"node\" or \"kibana\"").withRequiredArg().required();
    }

    @Override
    protected void validate(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!((Boolean)XPackSettings.ENROLLMENT_ENABLED.get(env.settings())).booleanValue()) {
            throw new UserException(78, "[xpack.security.enrollment.enabled] must be set to `true` to create an enrollment token");
        }
        String tokenScope = (String)this.scope.value(options);
        if (!ALLOWED_SCOPES.contains(tokenScope)) {
            terminal.errorPrintln("The scope of this enrollment token, can only be one of " + ALLOWED_SCOPES);
            throw new UserException(64, "Invalid scope");
        }
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env, String username, SecureString password) throws Exception {
        String tokenScope = (String)this.scope.value(options);
        URL baseUrl = options.has(this.urlOption) ? new URL((String)options.valueOf(this.urlOption)) : new URL(this.clientFunction.apply(env).getDefaultURL());
        try {
            ExternalEnrollmentTokenGenerator externalEnrollmentTokenGenerator = (ExternalEnrollmentTokenGenerator)this.createEnrollmentTokenFunction.apply((Object)env);
            if (tokenScope.equals("node")) {
                terminal.println((CharSequence)externalEnrollmentTokenGenerator.createNodeEnrollmentToken(username, password, baseUrl).getEncoded());
            } else {
                terminal.println((CharSequence)externalEnrollmentTokenGenerator.createKibanaEnrollmentToken(username, password, baseUrl).getEncoded());
            }
        }
        catch (Exception e) {
            terminal.errorPrintln("Unable to create enrollment token for scope [" + tokenScope + "]");
            throw new UserException(73, e.getMessage(), e.getCause());
        }
    }
}

