/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.action.user.GetUsersRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUsersResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportGetUsersAction
extends HandledTransportAction<GetUsersRequest, GetUsersResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;
    private final ReservedRealm reservedRealm;
    private final Authentication.RealmRef nativeRealmRef;
    private final ProfileService profileService;

    @Inject
    public TransportGetUsersAction(Settings settings, ActionFilters actionFilters, NativeUsersStore usersStore, TransportService transportService, ReservedRealm reservedRealm, Realms realms, ProfileService profileService) {
        super("cluster:admin/xpack/security/user/get", transportService, actionFilters, GetUsersRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settings = settings;
        this.usersStore = usersStore;
        this.reservedRealm = reservedRealm;
        this.nativeRealmRef = realms.getNativeRealmRef();
        this.profileService = profileService;
    }

    protected void doExecute(Task task, GetUsersRequest request, ActionListener<GetUsersResponse> listener) {
        String[] requestedUsers = request.usernames();
        boolean specificUsersRequested = requestedUsers != null && requestedUsers.length > 0;
        ArrayList<String> usersToSearchFor = new ArrayList<String>();
        ArrayList users = new ArrayList();
        ArrayList<String> realmLookup = new ArrayList<String>();
        if (specificUsersRequested) {
            for (String username : requestedUsers) {
                if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
                    realmLookup.add(username);
                    continue;
                }
                usersToSearchFor.add(username);
            }
        }
        ActionListener sendingListener = ActionListener.wrap(userLists -> {
            users.addAll(userLists.stream().flatMap(Collection::stream).filter(Objects::nonNull).toList());
            if (request.isWithProfileUid()) {
                this.resolveProfileUids(users, (ActionListener<Map<String, String>>)ActionListener.wrap(profileUidLookup -> listener.onResponse((Object)new GetUsersResponse((Collection)users, profileUidLookup)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new GetUsersResponse((Collection)users));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        GroupedActionListener groupListener = new GroupedActionListener(2, sendingListener);
        if (realmLookup.isEmpty()) {
            if (!specificUsersRequested) {
                this.reservedRealm.users((ActionListener<Collection<User>>)groupListener);
            } else {
                groupListener.onResponse(Collections.emptyList());
            }
        } else {
            GroupedActionListener realmGroupListener = new GroupedActionListener(realmLookup.size(), (ActionListener)groupListener);
            for (String user : realmLookup) {
                this.reservedRealm.lookupUser(user, (ActionListener<User>)realmGroupListener);
            }
        }
        if (specificUsersRequested && usersToSearchFor.isEmpty()) {
            groupListener.onResponse(Collections.emptyList());
        } else {
            this.usersStore.getUsers(usersToSearchFor.toArray(new String[usersToSearchFor.size()]), (ActionListener<Collection<User>>)groupListener);
        }
    }

    private void resolveProfileUids(List<User> users, ActionListener<Map<String, String>> listener) {
        List<Subject> subjects = users.stream().map(user -> {
            if (user instanceof AnonymousUser) {
                return new Subject(user, Authentication.RealmRef.newAnonymousRealmRef((String)((String)Node.NODE_NAME_SETTING.get(this.settings))));
            }
            if (ClientReservedRealm.isReserved((String)user.principal(), (Settings)this.settings)) {
                return new Subject(user, this.reservedRealm.realmRef());
            }
            return new Subject(user, this.nativeRealmRef);
        }).toList();
        this.profileService.searchProfilesForSubjects(subjects, (ActionListener<ProfileService.SubjectSearchResultsAndErrors<Profile>>)ActionListener.wrap(resultsAndErrors -> {
            if (resultsAndErrors == null) {
                listener.onResponse(null);
            } else if (resultsAndErrors.errors().isEmpty()) {
                assert (users.size() == resultsAndErrors.results().size());
                Map<String, String> profileUidLookup = resultsAndErrors.results().stream().filter(t -> Objects.nonNull(t.v2())).map(t -> new Tuple((Object)((Subject)t.v1()).getUser().principal(), (Object)((Profile)t.v2()).uid())).collect(Collectors.toUnmodifiableMap(Tuple::v1, Tuple::v2));
                listener.onResponse(profileUidLookup);
            } else {
                ElasticsearchStatusException exception = new ElasticsearchStatusException("failed to retrieve profile for users. please retry without fetching profile uid (with_profile_uid=false)", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                resultsAndErrors.errors().values().forEach(arg_0 -> exception.addSuppressed(arg_0));
                listener.onFailure((Exception)exception);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

