/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.sandbox.search.DocValuesNumbersQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;

class FieldExtractor {
    FieldExtractor() {
    }

    static void extractFields(Query query, Set<String> fields) throws UnsupportedOperationException {
        if (query instanceof BooleanQuery) {
            BooleanQuery q = (BooleanQuery)query;
            for (BooleanClause clause : q.clauses()) {
                FieldExtractor.extractFields(clause.getQuery(), fields);
            }
        } else if (query instanceof DisjunctionMaxQuery) {
            DisjunctionMaxQuery q = (DisjunctionMaxQuery)query;
            for (Query clause : q.getDisjuncts()) {
                FieldExtractor.extractFields(clause, fields);
            }
        } else if (query instanceof SpanTermQuery) {
            SpanTermQuery spanTermQuery = (SpanTermQuery)query;
            fields.add(spanTermQuery.getField());
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            fields.add(termQuery.getTerm().field());
        } else if (query instanceof SynonymQuery) {
            SynonymQuery q = (SynonymQuery)query;
            fields.add(((Term)q.getTerms().get(0)).field());
        } else if (query instanceof PhraseQuery) {
            PhraseQuery q = (PhraseQuery)query;
            fields.add(q.getTerms()[0].field());
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery q = (MultiPhraseQuery)query;
            fields.add(q.getTermArrays()[0][0].field());
        } else if (query instanceof PointRangeQuery) {
            PointRangeQuery pointRangeQuery = (PointRangeQuery)query;
            fields.add(pointRangeQuery.getField());
        } else if (query instanceof PointInSetQuery) {
            PointInSetQuery pointInSetQuery = (PointInSetQuery)query;
            fields.add(pointInSetQuery.getField());
        } else if (query instanceof DocValuesFieldExistsQuery) {
            DocValuesFieldExistsQuery docValuesFieldExistsQuery = (DocValuesFieldExistsQuery)query;
            fields.add(docValuesFieldExistsQuery.getField());
        } else if (query instanceof DocValuesNumbersQuery) {
            DocValuesNumbersQuery docValuesNumbersQuery = (DocValuesNumbersQuery)query;
            fields.add(docValuesNumbersQuery.getField());
        } else if (query instanceof IndexOrDocValuesQuery) {
            IndexOrDocValuesQuery indexOrDocValuesQuery = (IndexOrDocValuesQuery)query;
            try {
                HashSet<String> dvQueryFields = new HashSet<String>(1);
                FieldExtractor.extractFields(indexOrDocValuesQuery.getRandomAccessQuery(), dvQueryFields);
                fields.addAll(dvQueryFields);
            }
            catch (UnsupportedOperationException e) {
                FieldExtractor.extractFields(indexOrDocValuesQuery.getIndexQuery(), fields);
            }
        } else if (query instanceof TermInSetQuery) {
            TermInSetQuery termInSetQuery = (TermInSetQuery)query;
            PrefixCodedTerms.TermIterator termIterator = termInSetQuery.getTermData().iterator();
            if (termIterator.next() != null) {
                fields.add(termIterator.field());
            }
        } else if (!(query instanceof MatchAllDocsQuery) && !(query instanceof MatchNoDocsQuery)) {
            throw new UnsupportedOperationException();
        }
    }
}

