/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;

public final class SecuritySearchOperationListener
implements SearchOperationListener {
    private final SecurityContext securityContext;
    private final AuditTrailService auditTrailService;

    public SecuritySearchOperationListener(SecurityContext securityContext, AuditTrailService auditTrail) {
        this.securityContext = securityContext;
        this.auditTrailService = auditTrail;
    }

    public void onNewScrollContext(ReaderContext readerContext) {
        readerContext.putInContext("_xpack_security_authentication", (Object)this.securityContext.getAuthentication());
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.securityContext.getThreadContext().getTransient("_indices_permissions");
        assert (indicesAccessControl != null) : "thread context does not contain index access control";
        readerContext.putInContext("_indices_permissions", (Object)indicesAccessControl);
    }

    public void validateReaderContext(ReaderContext readerContext, TransportRequest request) {
        if (readerContext.scrollContext() != null) {
            Authentication originalAuth = (Authentication)readerContext.getFromContext("_xpack_security_authentication");
            Authentication current = this.securityContext.getAuthentication();
            ThreadContext threadContext = this.securityContext.getThreadContext();
            String action = (String)threadContext.getTransient("_originating_action_name");
            SecuritySearchOperationListener.ensureAuthenticatedUserIsSame(originalAuth, current, this.auditTrailService, readerContext.id(), action, request, AuditUtil.extractRequestId(threadContext), (AuthorizationEngine.AuthorizationInfo)threadContext.getTransient("_authz_info"));
            if (null == this.securityContext.getThreadContext().getTransient("_indices_permissions")) {
                IndicesAccessControl scrollIndicesAccessControl = (IndicesAccessControl)readerContext.getFromContext("_indices_permissions");
                assert (scrollIndicesAccessControl != null) : "scroll does not contain index access control";
                this.securityContext.getThreadContext().putTransient("_indices_permissions", (Object)scrollIndicesAccessControl);
            }
        }
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        this.ensureIndicesAccessControlForScrollThreadContext(searchContext);
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        this.ensureIndicesAccessControlForScrollThreadContext(searchContext);
    }

    void ensureIndicesAccessControlForScrollThreadContext(SearchContext searchContext) {
        IndicesAccessControl threadIndicesAccessControl;
        if (searchContext.readerContext().scrollContext() != null && null == (threadIndicesAccessControl = (IndicesAccessControl)this.securityContext.getThreadContext().getTransient("_indices_permissions"))) {
            throw new ElasticsearchSecurityException("Unexpected null indices access control for search context [" + searchContext.id() + "] for request [" + searchContext.request().getDescription() + "] with source [" + searchContext.source() + "]", new Object[0]);
        }
    }

    static void ensureAuthenticatedUserIsSame(Authentication original, Authentication current, AuditTrailService auditTrailService, ShardSearchContextId id, String action, TransportRequest request, String requestId, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        boolean sameUser = original.canAccessResourcesOf(current);
        if (!sameUser) {
            auditTrailService.get().accessDenied(requestId, current, action, request, authorizationInfo);
            throw new SearchContextMissingException(id);
        }
    }
}

