/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapMetadataResolverSettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySIDUtil;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

public class LdapMetadataResolver {
    private final String[] attributeNames;
    private final boolean ignoreReferralErrors;

    public LdapMetadataResolver(RealmConfig realmConfig, boolean ignoreReferralErrors) {
        this((Collection)realmConfig.getSetting(LdapMetadataResolverSettings.ADDITIONAL_METADATA_SETTING), ignoreReferralErrors);
    }

    LdapMetadataResolver(Collection<String> attributeNames, boolean ignoreReferralErrors) {
        this.attributeNames = attributeNames.toArray(new String[attributeNames.size()]);
        this.ignoreReferralErrors = ignoreReferralErrors;
    }

    public String[] attributeNames() {
        return this.attributeNames;
    }

    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<Map<String, Object>> listener) {
        if (this.attributeNames.length == 0) {
            listener.onResponse(Map.of());
        } else if (attributes != null) {
            listener.onResponse(this.toMap(name -> this.findAttribute(attributes, (String)name)));
        } else {
            LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                if (entry == null) {
                    listener.onResponse(Map.of());
                } else {
                    listener.onResponse(this.toMap(arg_0 -> ((SearchResultEntry)entry).getAttribute(arg_0)));
                }
            }, arg_0 -> listener.onFailure(arg_0)), this.attributeNames);
        }
    }

    private Attribute findAttribute(Collection<Attribute> attributes, String name) {
        return attributes.stream().filter(attr -> attr.getName().equals(name)).findFirst().orElse(null);
    }

    private Map<String, Object> toMap(Function<String, Attribute> attributes) {
        return Arrays.stream(this.attributeNames).map(attributes).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(attr -> attr.getName(), attr -> {
            String[] values = attr.getValues();
            if (attr.getName().equals("tokenGroups")) {
                return values.length == 1 ? ActiveDirectorySIDUtil.convertToString(attr.getValueByteArrays()[0]) : Arrays.stream(attr.getValueByteArrays()).map(sidBytes -> ActiveDirectorySIDUtil.convertToString(sidBytes)).collect(Collectors.toList());
            }
            return values.length == 1 ? values[0] : List.of(values);
        }));
    }
}

