/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityUsageServices;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

public class SecurityUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final Realms realms;
    private final CompositeRolesStore rolesStore;
    private final NativeRoleMappingStore roleMappingStore;
    private final IPFilter ipFilter;

    @Inject
    public SecurityUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, XPackLicenseState licenseState, SecurityUsageServices securityServices) {
        super(XPackUsageFeatureAction.SECURITY.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.settings = settings;
        this.licenseState = licenseState;
        this.realms = securityServices.realms;
        this.rolesStore = securityServices.rolesStore;
        this.roleMappingStore = securityServices.roleMappingStore;
        this.ipFilter = securityServices.ipFilter;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Map<String, Object> sslUsage = SecurityUsageTransportAction.sslUsage(this.settings);
        Map<String, Object> tokenServiceUsage = SecurityUsageTransportAction.tokenServiceUsage(this.settings);
        Map<String, Object> apiKeyServiceUsage = SecurityUsageTransportAction.apiKeyServiceUsage(this.settings);
        Map<String, Object> auditUsage = SecurityUsageTransportAction.auditUsage(this.settings);
        Map<String, Object> ipFilterUsage = SecurityUsageTransportAction.ipFilterUsage(this.ipFilter);
        Map<String, Boolean> anonymousUsage = Collections.singletonMap("enabled", AnonymousUser.isAnonymousEnabled((Settings)this.settings));
        Map<String, Object> fips140Usage = SecurityUsageTransportAction.fips140Usage(this.settings);
        Map<String, Object> operatorPrivilegesUsage = Map.of("available", Security.OPERATOR_PRIVILEGES_FEATURE.checkWithoutTracking(this.licenseState), "enabled", OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.get(this.settings));
        AtomicReference rolesUsageRef = new AtomicReference();
        AtomicReference roleMappingUsageRef = new AtomicReference();
        AtomicReference realmsUsageRef = new AtomicReference();
        boolean enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings);
        CountDown countDown = new CountDown(3);
        Runnable doCountDown = () -> {
            if (countDown.countDown()) {
                SecurityFeatureSetUsage usage = new SecurityFeatureSetUsage(enabled, (Map)realmsUsageRef.get(), (Map)rolesUsageRef.get(), (Map)roleMappingUsageRef.get(), sslUsage, auditUsage, ipFilterUsage, anonymousUsage, tokenServiceUsage, apiKeyServiceUsage, fips140Usage, operatorPrivilegesUsage);
                listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)usage));
            }
        };
        ActionListener rolesStoreUsageListener = ActionListener.wrap(rolesStoreUsage -> {
            rolesUsageRef.set(rolesStoreUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener roleMappingStoreUsageListener = ActionListener.wrap(nativeRoleMappingStoreUsage -> {
            Map<String, Map> usage = Collections.singletonMap("native", nativeRoleMappingStoreUsage);
            roleMappingUsageRef.set(usage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener realmsUsageListener = ActionListener.wrap(realmsUsage -> {
            realmsUsageRef.set(realmsUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        if (this.rolesStore == null || !enabled) {
            rolesStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.rolesStore.usageStats((ActionListener<Map<String, Object>>)rolesStoreUsageListener);
        }
        if (this.roleMappingStore == null || !enabled) {
            roleMappingStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.roleMappingStore.usageStats((ActionListener<Map<String, Object>>)roleMappingStoreUsageListener);
        }
        if (this.realms == null || !enabled) {
            realmsUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.realms.usageStats((ActionListener<Map<String, Object>>)realmsUsageListener);
        }
    }

    static Map<String, Object> sslUsage(Settings settings) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            Map map = Maps.newMapWithExpectedSize((int)2);
            map.put("http", Collections.singletonMap("enabled", (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)));
            map.put("transport", Collections.singletonMap("enabled", (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)));
            return map;
        }
        return Collections.emptyMap();
    }

    static Map<String, Object> tokenServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> apiKeyServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> auditUsage(Settings settings) {
        Map map = Maps.newMapWithExpectedSize((int)2);
        map.put("enabled", XPackSettings.AUDIT_ENABLED.get(settings));
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(settings)).booleanValue()) {
            map.put("outputs", Arrays.asList("logfile"));
        }
        return map;
    }

    static Map<String, Object> ipFilterUsage(@Nullable IPFilter ipFilter) {
        if (ipFilter == null) {
            return IPFilter.DISABLED_USAGE_STATS;
        }
        return ipFilter.usageStats();
    }

    static Map<String, Object> fips140Usage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.FIPS_MODE_ENABLED.get(settings));
    }
}

