/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.esnative.NativeRealm;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.file.FileRealm;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosRealm;
import org.elasticsearch.xpack.security.authc.ldap.LdapRealm;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectRealm;
import org.elasticsearch.xpack.security.authc.pki.PkiRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.support.RoleMappingFileBootstrapCheck;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public final class InternalRealms {
    private static final Set<String> XPACK_TYPES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"native", "file", "active_directory", "ldap", "pki", "saml", "kerberos", "oidc"}));
    private static final Set<String> STANDARD_TYPES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"native", "file", "active_directory", "ldap", "pki"}));

    static boolean isXPackRealm(String type) {
        if (XPACK_TYPES.contains(type)) {
            return true;
        }
        return "reserved".equals(type);
    }

    public static Collection<String> getConfigurableRealmsTypes() {
        return Collections.unmodifiableSet(XPACK_TYPES);
    }

    static boolean isStandardRealm(String type) {
        return STANDARD_TYPES.contains(type);
    }

    public static Map<String, Realm.Factory> getFactories(ThreadPool threadPool, ResourceWatcherService resourceWatcherService, SSLService sslService, NativeUsersStore nativeUsersStore, NativeRoleMappingStore nativeRoleMappingStore, SecurityIndexManager securityIndex) {
        HashMap<String, Realm.Factory> map = new HashMap<String, Realm.Factory>();
        map.put("file", config -> new FileRealm(config, resourceWatcherService, threadPool));
        map.put("native", config -> {
            NativeRealm nativeRealm = new NativeRealm(config, nativeUsersStore, threadPool);
            securityIndex.addStateListener(nativeRealm::onSecurityIndexStateChange);
            return nativeRealm;
        });
        map.put("active_directory", config -> new LdapRealm(config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("ldap", config -> new LdapRealm(config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("pki", config -> new PkiRealm(config, resourceWatcherService, nativeRoleMappingStore));
        map.put("saml", config -> SamlRealm.create(config, sslService, resourceWatcherService, nativeRoleMappingStore));
        map.put("kerberos", config -> new KerberosRealm(config, nativeRoleMappingStore, threadPool));
        map.put("oidc", config -> new OpenIdConnectRealm(config, sslService, nativeRoleMappingStore, resourceWatcherService));
        return Collections.unmodifiableMap(map);
    }

    private InternalRealms() {
    }

    public static List<BootstrapCheck> getBootstrapChecks(Settings globalSettings, Environment env) {
        HashSet realmTypes = Sets.newHashSet((Object[])new String[]{"active_directory", "ldap", "pki"});
        List<BootstrapCheck> checks = RealmSettings.getRealmSettings((Settings)globalSettings).keySet().stream().filter(id -> realmTypes.contains(id.getType())).map(id -> new RealmConfig(id, globalSettings, env, null)).map(RoleMappingFileBootstrapCheck::create).filter(Objects::nonNull).collect(Collectors.toList());
        return checks;
    }
}

